/*
 * Decompiled with CFR 0.152.
 */
package io.takari.jpgp;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;

public class PgpKeyRingLoader {
    private static final File DEFAULT_KEYRING = new File(new File(System.getProperty("user.home")), ".gnupg/secring.gpg");

    public PGPSecretKey load() throws IOException {
        return this.load(DEFAULT_KEYRING, null);
    }

    public PGPSecretKey load(File keyRing) throws IOException {
        return this.load(keyRing, null);
    }

    public PGPSecretKey load(File keyRing, String id) throws IOException {
        if (!keyRing.exists()) {
            throw new IOException("No such key ring file exists: " + keyRing);
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try (InputStream in = PGPUtil.getDecoderStream((InputStream)new FileInputStream(keyRing));){
            Object pgpObject;
            PGPObjectFactory pgpObjectFactory = new PGPObjectFactory(in, (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
            while ((pgpObject = pgpObjectFactory.nextObject()) != null) {
                if (!(pgpObject instanceof PGPSecretKeyRing)) {
                    throw new IOException("Expecting a secret key but found " + pgpObject);
                }
                PGPSecretKeyRing key = (PGPSecretKeyRing)pgpObject;
                if (id == null) {
                    return key.getSecretKey();
                }
                Iterator jtr = key.getSecretKeys();
                while (jtr.hasNext()) {
                    PGPSecretKey secretKey = (PGPSecretKey)jtr.next();
                    if (id.equalsIgnoreCase(Long.toHexString(secretKey.getPublicKey().getKeyID() & 0xFFFFFFFFFFFFFFFFL))) {
                        return secretKey;
                    }
                    Iterator ktr = secretKey.getUserIDs();
                    while (ktr.hasNext()) {
                        String s = (String)ktr.next();
                        if (!s.contains(id)) continue;
                        return secretKey;
                    }
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throw new IOException("no id: " + id);
    }

    public static void main(String[] args) throws Exception {
        new PgpKeyRingLoader().load();
    }
}

