/*
 * Decompiled with CFR 0.152.
 */
package io.takari.jpgp;

import io.takari.jpgp.IOUtils;
import io.takari.jpgp.PgpSupport;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Iterator;
import org.bouncycastle.bcpg.ArmoredInputStream;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedData;
import org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPOnePassSignature;
import org.bouncycastle.openpgp.PGPOnePassSignatureList;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyEncryptedData;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.PGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.PGPKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.PublicKeyDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.bc.BcPGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPublicKeyDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.bc.BcPublicKeyKeyEncryptionMethodGenerator;

public class PgpMessageEncryptor
extends PgpSupport {
    private void encryptAndSign(PGPSecretKey pgpSecretKey, String password, String inputDataName, InputStream inputData, OutputStream encryptedDataStream) throws PGPException, IOException {
        PGPSignatureGenerator pgpSignatureGenerator = null;
        PGPPrivateKey signingKey = null;
        if (pgpSecretKey != null) {
            signingKey = this.findPrivateKey(pgpSecretKey, password);
        }
        PGPCompressedDataGenerator compressedDataGenerator = new PGPCompressedDataGenerator(1);
        Throwable throwable = null;
        Object var10_11 = null;
        try (BCPGOutputStream compressedDataStream = new BCPGOutputStream(compressedDataGenerator.open(encryptedDataStream));){
            if (signingKey != null) {
                pgpSignatureGenerator = new PGPSignatureGenerator((PGPContentSignerBuilder)new BcPGPContentSignerBuilder(signingKey.getPublicKeyPacket().getAlgorithm(), 8));
                pgpSignatureGenerator.init(0, signingKey);
                pgpSignatureGenerator.generateOnePassVersion(false).encode((OutputStream)compressedDataStream);
            }
            PGPLiteralDataGenerator literalDataGenerator = new PGPLiteralDataGenerator(false);
            Throwable throwable2 = null;
            Object var14_17 = null;
            try (OutputStream literalDataOutputStream = literalDataGenerator.open((OutputStream)compressedDataStream, 'b', inputDataName, new Date(), new byte[4096]);){
                IOUtils.StreamHandler streamHandler = null;
                if (signingKey != null) {
                    streamHandler = (arg_0, arg_1, arg_2) -> ((PGPSignatureGenerator)pgpSignatureGenerator).update(arg_0, arg_1, arg_2);
                }
                IOUtils.copy(inputData, literalDataOutputStream, new byte[4096], streamHandler);
                literalDataGenerator.close();
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
            if (signingKey != null) {
                pgpSignatureGenerator.generate().encode((OutputStream)compressedDataStream);
            }
            compressedDataGenerator.close();
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    protected int getEncryptionAlgorithm() {
        return 9;
    }

    public boolean encrypt(InputStream publicKeyOfRecipient, String inputDataName, InputStream plainInputData, OutputStream target) {
        return this.encrypt(publicKeyOfRecipient, null, null, null, inputDataName, plainInputData, target);
    }

    public boolean encrypt(InputStream publicKeyOfRecipient, InputStream privateKeyOfSender, String userIdOfSender, String passwordOfSendersPrivateKey, String inputDataName, InputStream plainInputData, OutputStream target) {
        boolean result = true;
        PGPPublicKey pgpPublicKey = this.findPublicKey(publicKeyOfRecipient, pgpKey -> pgpKey.isEncryptionKey() && !pgpKey.isMasterKey());
        if (pgpPublicKey != null) {
            try {
                Throwable throwable = null;
                Object var11_12 = null;
                try (ArmoredOutputStream wrappedTargetStream = new ArmoredOutputStream(target);){
                    BcPGPDataEncryptorBuilder encryptorBuilder = new BcPGPDataEncryptorBuilder(this.getEncryptionAlgorithm());
                    encryptorBuilder.setWithIntegrityPacket(true);
                    PGPEncryptedDataGenerator encryptedDataGenerator = new PGPEncryptedDataGenerator((PGPDataEncryptorBuilder)encryptorBuilder);
                    encryptedDataGenerator.addMethod((PGPKeyEncryptionMethodGenerator)new BcPublicKeyKeyEncryptionMethodGenerator(pgpPublicKey));
                    PGPSecretKey pgpSecretKey = null;
                    if (privateKeyOfSender != null) {
                        pgpSecretKey = this.findSecretKey(privateKeyOfSender, userIdOfSender);
                    }
                    Throwable throwable2 = null;
                    Object var17_20 = null;
                    try (OutputStream encryptedDataStream = encryptedDataGenerator.open((OutputStream)wrappedTargetStream, new byte[4096]);){
                        this.encryptAndSign(pgpSecretKey, passwordOfSendersPrivateKey, inputDataName, plainInputData, encryptedDataStream);
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (IOException | PGPException throwable) {
                result = false;
            }
        } else {
            result = false;
        }
        return result;
    }

    public boolean decrypt(String passwordOfReceiversPrivateKey, InputStream privateKeyOfReceiver, InputStream encryptedData, OutputStream target) {
        return this.decrypt(passwordOfReceiversPrivateKey, privateKeyOfReceiver, null, encryptedData, target);
    }

    public boolean decrypt(String passwordOfReceiversPrivateKey, InputStream privateKeyOfReceiver, InputStream publicKeyOfSender, InputStream encryptedData, OutputStream target) {
        boolean result = true;
        try {
            Object var9_11;
            Throwable throwable;
            PGPPublicKeyRingCollection publicKeyRingCollection = null;
            if (publicKeyOfSender != null) {
                throwable = null;
                var9_11 = null;
                try (ArmoredInputStream armoredInputStream = new ArmoredInputStream(publicKeyOfSender);){
                    publicKeyRingCollection = new PGPPublicKeyRingCollection((InputStream)armoredInputStream, (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            throwable = null;
            var9_11 = null;
            try (InputStream in = PGPUtil.getDecoderStream((InputStream)encryptedData);){
                PGPObjectFactory objectFactory = new PGPObjectFactory(in, (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
                Object firstObject = objectFactory.nextObject();
                PGPEncryptedDataList dataList = firstObject instanceof PGPEncryptedDataList ? (PGPEncryptedDataList)firstObject : (PGPEncryptedDataList)objectFactory.nextObject();
                PGPPrivateKey pgpPrivateKey = null;
                PGPEncryptedData pgpEncryptedData = null;
                Iterator iterator = dataList.getEncryptedDataObjects();
                while (pgpPrivateKey == null && iterator.hasNext()) {
                    pgpEncryptedData = (PGPEncryptedData)iterator.next();
                    pgpPrivateKey = this.findPrivateKey(privateKeyOfReceiver, ((PGPPublicKeyEncryptedData)pgpEncryptedData).getKeyID(), passwordOfReceiversPrivateKey);
                }
                BcPublicKeyDataDecryptorFactory publicKeyDataDecryptorFactory = new BcPublicKeyDataDecryptorFactory(pgpPrivateKey);
                Throwable throwable3 = null;
                Object var19_24 = null;
                try (InputStream clearText = ((PGPPublicKeyEncryptedData)pgpEncryptedData).getDataStream((PublicKeyDataDecryptorFactory)publicKeyDataDecryptorFactory);){
                    Object message;
                    PGPObjectFactory pgpObjectFactory = new PGPObjectFactory(clearText, (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
                    PGPOnePassSignatureList onePassSignatureList = null;
                    PGPOnePassSignature onePassSignature = null;
                    PGPSignatureList signatures = null;
                    PGPPublicKey pgpPublicKey = null;
                    while ((message = pgpObjectFactory.nextObject()) != null) {
                        if (message instanceof PGPCompressedData) {
                            PGPCompressedData compressedData = (PGPCompressedData)message;
                            pgpObjectFactory = new PGPObjectFactory(compressedData.getDataStream(), (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
                        }
                        if (message instanceof PGPLiteralData) {
                            PGPLiteralData literalData = (PGPLiteralData)message;
                            Throwable throwable4 = null;
                            Object var30_38 = null;
                            try (InputStream literalDataStream = literalData.getInputStream();){
                                IOUtils.StreamHandler streamHandler = null;
                                if (onePassSignature != null) {
                                    streamHandler = (arg_0, arg_1, arg_2) -> ((PGPOnePassSignature)onePassSignature).update(arg_0, arg_1, arg_2);
                                }
                                IOUtils.copy(literalDataStream, target, new byte[4096], streamHandler);
                                continue;
                            }
                            catch (Throwable throwable5) {
                                if (throwable4 == null) {
                                    throwable4 = throwable5;
                                } else if (throwable4 != throwable5) {
                                    throwable4.addSuppressed(throwable5);
                                }
                                throw throwable4;
                            }
                        }
                        if (message instanceof PGPOnePassSignatureList) {
                            onePassSignatureList = (PGPOnePassSignatureList)message;
                            if (publicKeyOfSender == null) continue;
                            onePassSignature = onePassSignatureList.get(0);
                            pgpPublicKey = publicKeyRingCollection.getPublicKey(onePassSignature.getKeyID());
                            onePassSignature.init((PGPContentVerifierBuilderProvider)new BcPGPContentVerifierBuilderProvider(), pgpPublicKey);
                            continue;
                        }
                        if (!(message instanceof PGPSignatureList)) continue;
                        signatures = (PGPSignatureList)message;
                    }
                    int i = 0;
                    while (onePassSignatureList != null && i < onePassSignatureList.size()) {
                        if (pgpPublicKey != null && signatures != null) {
                            PGPSignature signature = signatures.get(i);
                            if (onePassSignature.verify(signature)) {
                                Iterator it = pgpPublicKey.getUserIDs();
                                while (it.hasNext()) {
                                    String cfr_ignored_0 = (String)it.next();
                                }
                            } else {
                                result = false;
                            }
                        }
                        ++i;
                    }
                    if (pgpEncryptedData.isIntegrityProtected() && !pgpEncryptedData.verify()) {
                        result = false;
                    }
                }
                catch (Throwable throwable6) {
                    if (throwable3 == null) {
                        throwable3 = throwable6;
                    } else if (throwable3 != throwable6) {
                        throwable3.addSuppressed(throwable6);
                    }
                    throw throwable3;
                }
            }
            catch (Throwable throwable7) {
                if (throwable == null) {
                    throwable = throwable7;
                } else if (throwable != throwable7) {
                    throwable.addSuppressed(throwable7);
                }
                throw throwable;
            }
        }
        catch (IOException | PGPException throwable) {
            result = false;
        }
        return result;
    }
}

