/*
 * Decompiled with CFR 0.152.
 */
package io.takari.jpgp;

import io.takari.jpgp.IOUtils;
import io.takari.jpgp.PgpSupport;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import org.bouncycastle.bcpg.ArmoredInputStream;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentVerifierBuilderProvider;

public class PgpMessageSigner
extends PgpSupport {
    public boolean verifyMessage(InputStream publicKeyOfSender, InputStream message, InputStream signatureStream) {
        boolean result = false;
        try {
            Throwable throwable = null;
            Object var6_7 = null;
            try (ArmoredInputStream armordPublicKeyStream = new ArmoredInputStream(signatureStream);){
                Object pgpObject;
                PGPObjectFactory pgpObjectFactory = new PGPObjectFactory((InputStream)armordPublicKeyStream, (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
                while ((pgpObject = pgpObjectFactory.nextObject()) != null) {
                    if (!(pgpObject instanceof PGPSignatureList)) continue;
                    PGPSignatureList signatureList = (PGPSignatureList)pgpObject;
                    for (PGPSignature signature : signatureList) {
                        PGPPublicKey pgpPublicKey = this.findPublicKey(publicKeyOfSender, pgpKey -> pgpKey.getKeyID() == signature.getKeyID());
                        if (pgpPublicKey == null) continue;
                        signature.init((PGPContentVerifierBuilderProvider)new BcPGPContentVerifierBuilderProvider(), pgpPublicKey);
                        IOUtils.process(message, (arg_0, arg_1, arg_2) -> ((PGPSignature)signature).update(arg_0, arg_1, arg_2));
                        result = signature.verify();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | PGPException throwable) {
            result = false;
        }
        return result;
    }

    public boolean signMessage(InputStream privateKeyOfSender, String userIdForPrivateKey, String passwordOfPrivateKey, InputStream message, OutputStream signature) {
        try {
            PGPPrivateKey privateKey = this.findPrivateKey(privateKeyOfSender, passwordOfPrivateKey, (PGPSecretKey secretKey) -> {
                boolean result1 = secretKey.isSigningKey();
                if (result1) {
                    Iterator userIdIterator = secretKey.getUserIDs();
                    boolean containsUserId = false;
                    while (userIdIterator.hasNext() && !containsUserId) {
                        containsUserId = userIdForPrivateKey.equals(userIdIterator.next());
                    }
                }
                return result1;
            });
            return this.signatureGenerator(message, signature, privateKey);
        }
        catch (IOException | PGPException throwable) {
            return false;
        }
    }

    public void signMessage(PGPSecretKey secretKey, String passwordOfPrivateKey, InputStream message, OutputStream signature) throws PGPException, IOException {
        PGPPrivateKey privateKey = this.findPrivateKey(secretKey, passwordOfPrivateKey);
        this.signatureGenerator(message, signature, privateKey);
    }

    private boolean signatureGenerator(InputStream message, OutputStream signature, PGPPrivateKey privateKey) throws PGPException, IOException {
        PGPSignatureGenerator signatureGenerator = new PGPSignatureGenerator((PGPContentSignerBuilder)new BcPGPContentSignerBuilder(privateKey.getPublicKeyPacket().getAlgorithm(), 8));
        signatureGenerator.init(0, privateKey);
        Throwable throwable = null;
        Object var6_7 = null;
        try (BCPGOutputStream outputStream = new BCPGOutputStream((OutputStream)new ArmoredOutputStream(signature));){
            IOUtils.process(message, (arg_0, arg_1, arg_2) -> ((PGPSignatureGenerator)signatureGenerator).update(arg_0, arg_1, arg_2));
            signatureGenerator.generate().encode((OutputStream)outputStream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return true;
    }
}

