/*
 * Decompiled with CFR 0.152.
 */
package io.takari.jpgp;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.bouncycastle.bcpg.ArmoredInputStream;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.bc.BcPBESecretKeyDecryptorBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPDigestCalculatorProvider;

public abstract class PgpSupport {
    protected PGPSecretKey retrieveSecretKey(PGPSecretKeyRingCollection secretKeyRingCollection, KeyFilter<PGPSecretKey> keyFilter) {
        PGPSecretKey result = null;
        Iterator secretKeyRingIterator = secretKeyRingCollection.getKeyRings();
        while (result == null && secretKeyRingIterator.hasNext()) {
            PGPSecretKeyRing secretKeyRing = (PGPSecretKeyRing)secretKeyRingIterator.next();
            Iterator secretKeyIterator = secretKeyRing.getSecretKeys();
            while (secretKeyIterator.hasNext()) {
                PGPSecretKey secretKey = (PGPSecretKey)secretKeyIterator.next();
                if (!keyFilter.accept(secretKey)) continue;
                result = secretKey;
            }
        }
        return result;
    }

    protected PGPSecretKey findSecretKey(InputStream secretKey, String userId) throws IOException, PGPException {
        return this.findSecretKey(secretKey, (PGPSecretKey secretKey1) -> {
            boolean result = false;
            Iterator userIdIterator = secretKey1.getUserIDs();
            while (userIdIterator.hasNext() && !result) {
                result = userId.equals(userIdIterator.next());
            }
            return result;
        });
    }

    protected PGPSecretKey findSecretKey(InputStream secretKey, KeyFilter<PGPSecretKey> keyFilter) throws IOException, PGPException {
        PGPSecretKey result;
        Throwable throwable = null;
        Object var5_5 = null;
        try (ArmoredInputStream armoredSecretKey = new ArmoredInputStream(secretKey);){
            PGPSecretKeyRingCollection keyRingCollection = new PGPSecretKeyRingCollection((InputStream)armoredSecretKey, (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
            result = this.retrieveSecretKey(keyRingCollection, keyFilter);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return result;
    }

    protected PGPPrivateKey findPrivateKey(InputStream secretKey, long keyId, String password) throws PGPException, IOException {
        return this.findPrivateKey(secretKey, password, (PGPSecretKey secretKey1) -> secretKey1.getKeyID() == keyId);
    }

    protected PGPPrivateKey findPrivateKey(InputStream secretKey, String password, KeyFilter<PGPSecretKey> keyFilter) throws IOException, PGPException {
        return this.findPrivateKey(this.findSecretKey(secretKey, keyFilter), password);
    }

    protected PGPPrivateKey findPrivateKey(PGPSecretKey pgpSecretKey, String password) throws PGPException {
        PBESecretKeyDecryptor pbeSecretKeyDecryptor = new BcPBESecretKeyDecryptorBuilder((PGPDigestCalculatorProvider)new BcPGPDigestCalculatorProvider()).build(password.toCharArray());
        PGPPrivateKey result = pgpSecretKey.extractPrivateKey(pbeSecretKeyDecryptor);
        return result;
    }

    protected PGPPublicKey findPublicKey(InputStream publicKey, KeyFilter<PGPPublicKey> keyFilter) {
        return this.retrievePublicKey(this.readPublicKeyRing(publicKey), keyFilter);
    }

    protected PGPPublicKey retrievePublicKey(PGPPublicKeyRing publicKeyRing, KeyFilter<PGPPublicKey> keyFilter) {
        PGPPublicKey result = null;
        Iterator publicKeyIterator = publicKeyRing.getPublicKeys();
        while (result == null && publicKeyIterator.hasNext()) {
            PGPPublicKey key = (PGPPublicKey)publicKeyIterator.next();
            if (!keyFilter.accept(key)) continue;
            result = key;
        }
        return result;
    }

    protected PGPPublicKeyRing readPublicKeyRing(InputStream publicKey) {
        PGPPublicKeyRing result = null;
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (InputStream decoderStream = PGPUtil.getDecoderStream((InputStream)publicKey);){
                Object o;
                PGPObjectFactory pgpObjectFactory = new PGPObjectFactory(decoderStream, (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
                while ((o = pgpObjectFactory.nextObject()) != null && result == null) {
                    if (!(o instanceof PGPPublicKeyRing)) continue;
                    result = (PGPPublicKeyRing)o;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {}
        return result;
    }

    protected static interface KeyFilter<T> {
        public boolean accept(T var1);
    }
}

