/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.plugins;

import io.tesla.proviso.archive.UnArchiver;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Settings;
import org.apache.maven.wrapper.DefaultDownloader;

@Mojo(name="wrapper", requiresProject=false, aggregator=true)
public class WrapperMojo
extends AbstractMojo {
    private static final String DEFAULT_DOWNLOAD_BASE_URL = "https://repo.maven.apache.org/maven2";
    private static final String DEFAULT_MAVEN_VER = "3.6.0";
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Parameter(defaultValue="0.5.3", property="version")
    private String version;
    @Parameter(defaultValue="3.6.0", property="maven")
    private String maven;
    @Parameter(property="downloadBaseUrl")
    private String downloadBaseUrl;
    @Parameter(property="distributionUrl")
    private String distributionUrl;
    @Parameter(defaultValue="${settings}", readonly=true)
    private Settings settings;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File localRepository = new File(this.settings.getLocalRepository());
        String artifactPath = String.format("io/takari/maven-wrapper/%s/maven-wrapper-%s.tar.gz", this.version, this.version);
        String distroPath = String.format("org/apache/maven/apache-maven/%s/apache-maven-%s-bin.zip", this.maven, this.maven);
        String repoUrl = this.getRepoUrl();
        String wrapperUrl = String.format("%s/%s", repoUrl, artifactPath);
        String distroUrl = String.format("%s/%s", repoUrl, distroPath);
        File destination = new File(localRepository, artifactPath);
        this.getLog().debug((CharSequence)"Attempting to");
        this.getLog().debug((CharSequence)(" Download maven-wrapper from " + wrapperUrl));
        this.getLog().debug((CharSequence)(" Write maven-wrapper to " + destination.getAbsolutePath()));
        DefaultDownloader downloader = new DefaultDownloader("mvnw", this.version);
        try {
            downloader.download(new URI(wrapperUrl), destination);
            this.getLog().debug((CharSequence)("Downloaded maven-wrapper from " + wrapperUrl));
            Path rootDirectory = Paths.get(this.session.getExecutionRootDirectory(), new String[0]);
            UnArchiver unarchiver = UnArchiver.builder().useRoot(false).build();
            unarchiver.unarchive(destination, rootDirectory.toFile());
            this.getLog().debug((CharSequence)"Extracted maven-wrapper successfully.");
            this.updateMavenWrapperProperties(rootDirectory, wrapperUrl, distroUrl);
            this.getLog().info((CharSequence)"");
            this.getLog().info((CharSequence)("Maven Wrapper version " + this.version + " has been successfully set up for your project."));
            this.getLog().info((CharSequence)("Using Apache Maven: " + this.maven));
            this.getLog().info((CharSequence)("Repo URL in properties file: " + repoUrl));
            this.getLog().info((CharSequence)"");
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error installing the Maven Wrapper.", e);
        }
    }

    private void updateMavenWrapperProperties(Path rootDirectory, String wrapperUrl, String distroUrl) throws IOException {
        ArrayList<String> props = new ArrayList<String>();
        props.add("distributionUrl=" + distroUrl);
        props.add("wrapperUrl=" + wrapperUrl);
        Path wrapperProperties = rootDirectory.resolve(Paths.get(".mvn", "wrapper", "maven-wrapper.properties"));
        if (Files.isWritable(wrapperProperties)) {
            Files.write(wrapperProperties, props, Charset.forName("UTF-8"), new OpenOption[0]);
            this.getLog().debug((CharSequence)("Properties file updated, located at " + wrapperProperties));
        } else {
            this.getLog().debug((CharSequence)("Left existing properties file untouched. " + wrapperProperties));
        }
    }

    private String getRepoUrl() {
        String mvnwRepoUrl;
        String result = DEFAULT_DOWNLOAD_BASE_URL;
        if (!WrapperMojo.isNullOrEmpty(this.downloadBaseUrl)) {
            result = this.downloadBaseUrl;
            this.getLog().debug((CharSequence)"Setting repo URL from property.");
        }
        if (!WrapperMojo.isNullOrEmpty(mvnwRepoUrl = System.getenv("MVNW_REPOURL"))) {
            result = mvnwRepoUrl;
            this.getLog().debug((CharSequence)"Setting repo URL from environment variable.");
        } else if (this.settings.getMirrors() != null && this.settings.getMirrors().size() > 0) {
            for (Mirror current : this.settings.getMirrors()) {
                if (!"*".equals(current.getMirrorOf())) continue;
                result = current.getUrl();
                break;
            }
            this.getLog().debug((CharSequence)"Setting repo URL from mirro in settings file.");
        }
        this.getLog().debug((CharSequence)("Determined repo URL to use as " + result));
        return result;
    }

    private static boolean isNullOrEmpty(String value) {
        return value == null || value.isEmpty();
    }
}

