/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.timeline;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.CodeSource;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class WebUtils {
    public static void openUrl(String url) {
        String osName = System.getProperty("os.name");
        try {
            if (osName.startsWith("Mac OS")) {
                Class<?> fileMgr = Class.forName("com.apple.eio.FileManager");
                Method openURL = fileMgr.getDeclaredMethod("openURL", String.class);
                openURL.invoke(null, url);
            } else if (osName.startsWith("Windows")) {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
            } else {
                String[] browsers = new String[]{"firefox", "opera", "konqueror", "epiphany", "mozilla", "netscape"};
                String browser = null;
                int count = 0;
                while (count < browsers.length && browser == null) {
                    if (Runtime.getRuntime().exec(new String[]{"which", browsers[count]}).waitFor() == 0) {
                        browser = browsers[count];
                    }
                    ++count;
                }
                if (browser == null) {
                    throw new Exception("Could not find web browser");
                }
                Runtime.getRuntime().exec(new String[]{browser, url});
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void copyResourcesToDirectory(File jar, String jarDirectory, File outputDirectory) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (JarFile fromJar = new JarFile(jar);){
            Enumeration<JarEntry> entries = fromJar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (!entry.getName().startsWith(String.valueOf(jarDirectory) + "/") || entry.isDirectory()) continue;
                File dest = new File(outputDirectory + "/" + entry.getName().substring(jarDirectory.length() + 1));
                File parent = dest.getParentFile();
                if (parent != null) {
                    parent.mkdirs();
                }
                Throwable throwable2 = null;
                Object var11_14 = null;
                try {
                    FileOutputStream out = new FileOutputStream(dest);
                    try {
                        try (InputStream in = fromJar.getInputStream(entry);){
                            WebUtils.copy(in, out);
                        }
                        if (out == null) continue;
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        if (out != null) {
                            out.close();
                        }
                        throw throwable2;
                    }
                    out.close();
                }
                catch (Throwable throwable4) {
                    if (throwable2 == null) {
                        throwable2 = throwable4;
                    } else if (throwable2 != throwable4) {
                        throwable2.addSuppressed(throwable4);
                    }
                    throw throwable2;
                }
            }
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
            } else if (throwable != throwable5) {
                throwable.addSuppressed(throwable5);
            }
            throw throwable;
        }
    }

    private static void copy(InputStream from, OutputStream to) throws IOException {
        int r;
        byte[] buf = new byte[8192];
        while ((r = from.read(buf)) != -1) {
            to.write(buf, 0, r);
        }
    }

    public static void copyResourcesToDirectory(Class<?> clazz, String jarDirectory, File outputDirectory) throws IOException {
        CodeSource src = clazz.getProtectionDomain().getCodeSource();
        if (src != null) {
            WebUtils.copyResourcesToDirectory(WebUtils.urlToFile(src.getLocation()), jarDirectory, outputDirectory);
        }
    }

    private static File urlToFile(URL url) {
        File f;
        try {
            f = new File(url.toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            f = new File(url.getPath());
        }
        return f;
    }

    public void launch(String path, File jar, File outputDirectory) throws IOException {
        WebUtils.copyResourcesToDirectory(jar, "timeline", outputDirectory);
        WebUtils.openUrl(new File("/tmp/timeline/timeline.html").toURI().toURL().toExternalForm());
    }

    public static void main(String[] args) throws Exception {
        String path = "timeline/timeline.html";
        File jar = new File("/Users/jvanzyl/js/takari/maven-timeline/target/maven-timeline-1.4.jar");
        File outputDirectory = new File("/tmp/timeline");
        WebUtils w = new WebUtils();
        w.launch(path, jar, outputDirectory);
    }
}

