/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.timeline.buildevents;

import io.takari.maven.timeline.Event;
import io.takari.maven.timeline.Timeline;
import io.takari.maven.timeline.TimelineSerializer;
import io.takari.maven.timeline.WebUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.maven.execution.AbstractExecutionListener;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public final class BuildEventListener
extends AbstractExecutionListener {
    private final File mavenTimeline;
    private final String artifactId;
    private final String groupId;
    private final File output;
    private final long start;
    private final Map<Execution, Metric> executionMetrics = new ConcurrentHashMap<Execution, Metric>();
    private final Map<Execution, Event> timelineMetrics = new ConcurrentHashMap<Execution, Event>();
    private final Map<Long, AtomicLong> threadToTrackNum = new ConcurrentHashMap<Long, AtomicLong>();
    private final Map<Long, Integer> threadNumToColour = new ConcurrentHashMap<Long, Integer>();
    private final AtomicLong trackNum = new AtomicLong(0L);
    private final long startTime;

    public BuildEventListener(File output, File mavenTimeline, String artifactId, String groupId) {
        this.output = output;
        this.mavenTimeline = mavenTimeline;
        this.artifactId = artifactId;
        this.groupId = groupId;
        this.start = System.currentTimeMillis();
        this.startTime = this.nowInUtc();
    }

    private long millis() {
        return System.currentTimeMillis() - this.start;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mojoStarted(ExecutionEvent event) {
        Integer colour;
        Execution key = this.key(event);
        Long threadId = Thread.currentThread().getId();
        AtomicLong threadTrackNum = this.threadToTrackNum.get(threadId);
        if (threadTrackNum == null) {
            BuildEventListener buildEventListener = this;
            synchronized (buildEventListener) {
                if (threadTrackNum == null) {
                    threadTrackNum = new AtomicLong(this.trackNum.getAndIncrement());
                    this.threadToTrackNum.put(threadId, threadTrackNum);
                }
            }
        }
        if ((colour = this.threadNumToColour.get(threadId)) == null) {
            colour = 0;
            this.threadNumToColour.put(threadId, colour);
        } else {
            colour = 1 - colour;
            this.threadNumToColour.put(threadId, colour);
        }
        this.executionMetrics.put(key, new Metric(key, Thread.currentThread().getId(), this.millis()));
        this.timelineMetrics.put(key, new Event(threadTrackNum.get(), this.nowInUtc(), key.groupId, key.artifactId, key.phase, key.goal, key.id));
    }

    private long nowInUtc() {
        return new DateTime(DateTimeZone.UTC).getMillis();
    }

    public void mojoSkipped(ExecutionEvent event) {
        this.mojoEnd(event);
    }

    public void mojoSucceeded(ExecutionEvent event) {
        this.mojoEnd(event);
    }

    public void mojoFailed(ExecutionEvent event) {
        this.mojoEnd(event);
    }

    private void mojoEnd(ExecutionEvent event) {
        Event timelineMetric = this.timelineMetrics.get(this.key(event));
        Metric metric = this.executionMetrics.get(this.key(event));
        if (metric == null) {
            return;
        }
        metric.setEnd(this.millis());
        timelineMetric.setEnd(new DateTime(DateTimeZone.UTC).getMillis());
        timelineMetric.setDuration(metric.end - metric.start);
    }

    public void sessionEnded(ExecutionEvent event) {
        try {
            this.report();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Execution key(ExecutionEvent event) {
        MojoExecution mojo = event.getMojoExecution();
        MavenProject project = event.getProject();
        return new Execution(project.getGroupId(), project.getArtifactId(), mojo.getLifecyclePhase(), mojo.getGoal(), mojo.getExecutionId());
    }

    private void report() throws IOException {
        File path = this.output.getParentFile();
        if (!path.isDirectory() && !path.mkdirs()) {
            throw new IOException("Unable to create " + path);
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.output));){
            Metric.array(writer, this.executionMetrics.values());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.exportTimeline();
    }

    private void exportTimeline() throws IOException {
        long endTime = this.nowInUtc();
        WebUtils.copyResourcesToDirectory(((Object)((Object)this)).getClass(), "timeline", this.mavenTimeline.getParentFile());
        Throwable throwable = null;
        Object var4_4 = null;
        try (BufferedWriter mavenTimelineWriter = new BufferedWriter(new FileWriter(this.mavenTimeline));){
            Timeline timeline = new Timeline(this.startTime, endTime, this.groupId, this.artifactId, new ArrayList<Event>(this.timelineMetrics.values()));
            mavenTimelineWriter.write("window.timelineData = ");
            TimelineSerializer.serialize(mavenTimelineWriter, timeline);
            mavenTimelineWriter.write(";");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    static class Execution {
        final String groupId;
        final String artifactId;
        final String phase;
        final String goal;
        final String id;

        Execution(String groupId, String artifactId, String phase, String goal, String id) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.phase = phase;
            this.goal = goal;
            this.id = id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Execution execution = (Execution)o;
            if (this.groupId != null ? !this.groupId.equals(execution.groupId) : execution.groupId != null) {
                return false;
            }
            if (this.artifactId != null ? !this.artifactId.equals(execution.artifactId) : execution.artifactId != null) {
                return false;
            }
            if (this.phase != null ? !this.phase.equals(execution.phase) : execution.phase != null) {
                return false;
            }
            if (this.goal != null ? !this.goal.equals(execution.goal) : execution.goal != null) {
                return false;
            }
            return this.id != null ? this.id.equals(execution.id) : execution.id == null;
        }

        public int hashCode() {
            int result = this.groupId != null ? this.groupId.hashCode() : 0;
            result = 31 * result + (this.artifactId != null ? this.artifactId.hashCode() : 0);
            result = 31 * result + (this.phase != null ? this.phase.hashCode() : 0);
            result = 31 * result + (this.goal != null ? this.goal.hashCode() : 0);
            result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
            return result;
        }

        public String toString() {
            return String.valueOf(this.groupId) + ":" + this.artifactId + ":" + this.phase + ":" + this.goal + ":" + this.id;
        }
    }

    static class Metric {
        final Execution execution;
        final Long threadId;
        final Long start;
        Long end;

        Metric(Execution execution, Long threadId, Long start) {
            this.execution = execution;
            this.threadId = threadId;
            this.start = start;
        }

        void setEnd(Long end) {
            this.end = end;
        }

        String toJSON() {
            return this.record(this.value("groupId", this.execution.groupId), this.value("artifactId", this.execution.artifactId), this.value("phase", this.execution.phase), this.value("goal", this.execution.goal), this.value("id", this.execution.id), this.value("threadId", this.threadId), this.value("start", this.start), this.value("end", this.end));
        }

        private String value(String key, String value) {
            return "\"" + key + "\":\"" + value + "\"";
        }

        private String value(String key, Long value) {
            return "\"" + key + "\":" + value;
        }

        private String record(String ... values) {
            StringBuilder b = new StringBuilder();
            b.append("{");
            String[] stringArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                b.append(value).append(",");
                ++n2;
            }
            return b.deleteCharAt(b.length() - 1).append("}").toString();
        }

        static void array(Appendable a, Iterable<Metric> metrics) throws IOException {
            a.append("[");
            Iterator<Metric> it = metrics.iterator();
            if (it.hasNext()) {
                a.append(it.next().toJSON());
            }
            while (it.hasNext()) {
                a.append(",").append(it.next().toJSON());
            }
            a.append("]");
        }
    }
}

