/*
 * Decompiled with CFR 0.152.
 */
package io.tesla.maven.plugins.provisio;

import io.provis.MavenProvisioner;
import io.provis.model.ArtifactSet;
import io.provis.model.ProvisioArtifact;
import io.provis.model.ProvisioningRequest;
import io.provis.model.ProvisioningResult;
import io.provis.model.Runtime;
import io.takari.incrementalbuild.Incremental;
import io.tesla.maven.plugins.provisio.Provisio;
import java.io.File;
import java.util.Collections;
import java.util.Map;
import javax.inject.Inject;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.ArtifactType;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.artifact.DefaultArtifactType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="provision", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class ProvisioningMojo
extends AbstractMojo {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Inject
    private RepositorySystem repositorySystem;
    @Inject
    private Provisio provisio;
    @Inject
    private MavenProjectHelper projectHelper;
    @Incremental(configuration=Incremental.Configuration.ignore)
    @Parameter(defaultValue="${project}")
    protected MavenProject project;
    @Parameter(defaultValue="${repositorySystemSession}")
    private RepositorySystemSession repositorySystemSession;
    @Parameter(defaultValue="${project.build.directory}/${project.artifactId}-${project.version}")
    private File outputDirectory;
    @Parameter(required=true, defaultValue="${basedir}/src/main/provisio")
    private File descriptorDirectory;
    @Parameter(defaultValue="${session}")
    private MavenSession session;

    public void execute() throws MojoExecutionException, MojoFailureException {
        for (Runtime runtime : this.provisio.findDescriptors(this.descriptorDirectory, this.project)) {
            ProvisioningResult result;
            ArtifactSet runtimeArtifacts = this.getRuntimeClasspathAsArtifactSet();
            ProvisioArtifact projectArtifact = this.projectArtifact();
            if (projectArtifact != null) {
                runtime.addArtifactReference("projectArtifact", projectArtifact);
                runtimeArtifacts.addArtifact(projectArtifact);
                if (!this.project.getPackaging().equals("jar")) {
                    this.projectHelper.attachArtifact(this.project, "jar", projectArtifact.getFile());
                }
            }
            runtime.addArtifactSetReference("runtime.classpath", runtimeArtifacts);
            ProvisioningRequest request = new ProvisioningRequest();
            request.setOutputDirectory(this.outputDirectory);
            request.setRuntimeDescriptor(runtime);
            request.setVariables(runtime.getVariables());
            request.setManagedDependencies(this.provisio.getManagedDependencies(this.project));
            MavenProvisioner provisioner = new MavenProvisioner(this.repositorySystem, this.repositorySystemSession, this.project.getRemoteProjectRepositories());
            try {
                result = provisioner.provision(request);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Error provisioning assembly.", e);
            }
            if (result.getArchives() == null || result.getArchives().size() != 1) continue;
            File file = (File)result.getArchives().get(0);
            this.project.getArtifact().setFile(file);
        }
    }

    private ProvisioArtifact projectArtifact() {
        ProvisioArtifact jarArtifact = null;
        File jar = new File(this.project.getBuild().getDirectory(), String.valueOf(this.project.getArtifactId()) + "-" + this.project.getVersion() + ".jar");
        if (jar.exists()) {
            jarArtifact = new ProvisioArtifact(String.valueOf(this.project.getGroupId()) + ":" + this.project.getArtifactId() + ":" + this.project.getVersion());
            jarArtifact.setFile(jar);
        }
        return jarArtifact;
    }

    private ArtifactSet getRuntimeClasspathAsArtifactSet() {
        ArtifactSet artifactSet = new ArtifactSet();
        for (org.apache.maven.artifact.Artifact mavenArtifact : this.project.getArtifacts()) {
            artifactSet.addArtifact(new ProvisioArtifact(ProvisioningMojo.toArtifact(mavenArtifact)));
        }
        return artifactSet;
    }

    private static Artifact toArtifact(org.apache.maven.artifact.Artifact artifact) {
        if (artifact == null) {
            return null;
        }
        String version = artifact.getVersion();
        if (version == null && artifact.getVersionRange() != null) {
            version = artifact.getVersionRange().toString();
        }
        Map<String, String> props = null;
        if ("system".equals(artifact.getScope())) {
            String localPath = artifact.getFile() != null ? artifact.getFile().getPath() : "";
            props = Collections.singletonMap("localPath", localPath);
        }
        DefaultArtifact result = new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifact.getArtifactHandler().getExtension(), version, props, ProvisioningMojo.newArtifactType(artifact.getType(), artifact.getArtifactHandler()));
        result = result.setFile(artifact.getFile());
        return result;
    }

    private static ArtifactType newArtifactType(String id, ArtifactHandler handler) {
        return new DefaultArtifactType(id, handler.getExtension(), handler.getClassifier(), handler.getLanguage(), handler.isAddedToClasspath(), handler.isIncludesDependencies());
    }
}

