/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.plugins.compile;

import com.google.common.base.Stopwatch;
import io.takari.incrementalbuild.BuildContext;
import io.takari.incrementalbuild.Incremental;
import io.takari.incrementalbuild.spi.DefaultBuildContext;
import io.takari.maven.plugins.compile.AbstractCompiler;
import io.takari.maven.plugins.compile.javac.CompilerJavacLauncher;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;
import javax.tools.JavaFileObject;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCompileMojo
extends AbstractMojo {
    private static final String DEFAULT_COMPILER_LEVEL = "1.7";
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Parameter(property="encoding", defaultValue="${project.build.sourceEncoding}")
    private String encoding;
    @Parameter(property="maven.compiler.source", defaultValue="1.7")
    private String source;
    @Parameter(property="maven.compiler.target")
    private String target;
    @Parameter(property="maven.compiler.compilerId", defaultValue="javac")
    private String compilerId;
    @Parameter(property="maven.compiler.meminitial")
    private String meminitial;
    @Parameter(property="maven.compiler.maxmem")
    private String maxmem;
    @Parameter(defaultValue="none")
    private Proc proc = Proc.none;
    @Parameter
    private String[] annotationProcessors;
    @Parameter
    private Map<String, String> annotationProcessorOptions;
    @Parameter(property="maven.compiler.verbose", defaultValue="false")
    private boolean verbose;
    @Parameter(property="maven.compiler.debug", defaultValue="all")
    private String debug;
    @Parameter(property="maven.compiler.showWarnings", defaultValue="false")
    private boolean showWarnings;
    @Parameter(defaultValue="ignore")
    private AccessRulesViolation transitiveDependencyReference;
    @Parameter(defaultValue="ignore")
    private AccessRulesViolation privatePackageReference;
    @Incremental(configuration=Incremental.Configuration.ignore)
    @Parameter(defaultValue="${project.file}", readonly=true)
    private File pom;
    @Incremental(configuration=Incremental.Configuration.ignore)
    @Parameter(defaultValue="${project.basedir}", readonly=true)
    private File basedir;
    @Incremental(configuration=Incremental.Configuration.ignore)
    @Parameter(defaultValue="${project.build.directory}", readonly=true)
    private File buildDirectory;
    @Incremental(configuration=Incremental.Configuration.ignore)
    @Parameter(defaultValue="${plugin.pluginArtifact}", readonly=true)
    private Artifact pluginArtifact;
    @Incremental(configuration=Incremental.Configuration.ignore)
    @Parameter(defaultValue="${project.artifact}", readonly=true)
    private Artifact artifact;
    @Incremental(configuration=Incremental.Configuration.ignore)
    @Parameter(defaultValue="${project.dependencyArtifacts}", readonly=true)
    private Set<Artifact> directDependencies;
    @Component
    private Map<String, AbstractCompiler> compilers;
    @Component
    private DefaultBuildContext context;

    public Charset getSourceEncoding() {
        return this.encoding == null ? null : Charset.forName(this.encoding);
    }

    private List<BuildContext.InputMetadata<File>> getSources() throws IOException, MojoExecutionException {
        ArrayList<BuildContext.InputMetadata<File>> sources = new ArrayList<BuildContext.InputMetadata<File>>();
        StringBuilder msg = new StringBuilder();
        for (String sourcePath : this.getSourceRoots()) {
            File sourceRoot = new File(sourcePath);
            msg.append("\n").append(sourcePath);
            if (!sourceRoot.isDirectory()) {
                msg.append("\n   does not exist or not a directory, skiped");
                continue;
            }
            Set<String> includes = this.getIncludes();
            if (includes == null || includes.isEmpty()) {
                includes = Collections.singleton("**/*.java");
            } else {
                for (String include : includes) {
                    LinkedHashSet<String> illegal = new LinkedHashSet<String>();
                    if (!include.endsWith(JavaFileObject.Kind.SOURCE.extension)) {
                        illegal.add(include);
                    }
                    if (illegal.isEmpty()) continue;
                    throw new MojoExecutionException(String.format("<includes> patterns must end with %s. Illegal patterns: %s", JavaFileObject.Kind.SOURCE.extension, ((Object)illegal).toString()));
                }
            }
            Set<String> excludes = this.getExcludes();
            int sourceCount = 0;
            for (BuildContext.InputMetadata source : this.context.registerInputs(sourceRoot, includes, excludes)) {
                sources.add((BuildContext.InputMetadata<File>)source);
                ++sourceCount;
            }
            if (!this.log.isDebugEnabled()) continue;
            msg.append("\n   includes=").append(includes.toString());
            msg.append(" excludes=").append(excludes != null ? excludes.toString() : "[]");
            msg.append(" matched=").append(sourceCount);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Compile source roots:{}", (Object)msg);
        }
        return sources;
    }

    protected Set<File> getDirectDependencies() {
        LinkedHashSet<File> result = new LinkedHashSet<File>();
        for (Artifact artofact : this.directDependencies) {
            result.add(artofact.getFile());
        }
        return result;
    }

    protected abstract Set<String> getSourceRoots();

    protected abstract Set<String> getIncludes();

    protected abstract Set<String> getExcludes();

    protected abstract File getOutputDirectory();

    protected abstract List<File> getClasspath();

    protected abstract File getGeneratedSourcesDirectory();

    protected abstract boolean isSkip();

    protected abstract File getMainOutputDirectory();

    public void execute() throws MojoExecutionException, MojoFailureException {
        Stopwatch stopwatch = Stopwatch.createStarted();
        if (this.isSkip()) {
            this.log.info("Skipping compilation");
            this.context.markSkipExecution();
            return;
        }
        AbstractCompiler compiler = this.compilers.get(this.compilerId);
        if (compiler == null) {
            throw new MojoExecutionException("Unsupported compilerId" + this.compilerId);
        }
        try {
            List<BuildContext.InputMetadata<File>> sources = this.getSources();
            if (sources.isEmpty()) {
                this.log.info("No sources, skipping compilation");
                return;
            }
            this.mkdirs(this.getOutputDirectory());
            if (this.proc != Proc.none) {
                this.mkdirs(this.getGeneratedSourcesDirectory());
            }
            compiler.setOutputDirectory(this.getOutputDirectory());
            compiler.setSource(this.source);
            compiler.setTarget(AbstractCompileMojo.getTarget(this.target, this.source));
            compiler.setProc(this.proc);
            compiler.setGeneratedSourcesDirectory(this.getGeneratedSourcesDirectory());
            compiler.setAnnotationProcessors(this.annotationProcessors);
            compiler.setAnnotationProcessorOptions(this.annotationProcessorOptions);
            compiler.setVerbose(this.verbose);
            compiler.setPom(this.pom);
            compiler.setSourceEncoding(this.getSourceEncoding());
            compiler.setSourceRoots(this.getSourceRoots());
            compiler.setDebug(AbstractCompileMojo.parseDebug(this.debug));
            compiler.setShowWarnings(this.showWarnings);
            compiler.setTransitiveDependencyReference(this.transitiveDependencyReference);
            compiler.setPrivatePackageReference(this.privatePackageReference);
            if (compiler instanceof CompilerJavacLauncher) {
                ((CompilerJavacLauncher)compiler).setBasedir(this.basedir);
                ((CompilerJavacLauncher)compiler).setJar(this.pluginArtifact.getFile());
                ((CompilerJavacLauncher)compiler).setBuildDirectory(this.buildDirectory);
                ((CompilerJavacLauncher)compiler).setMeminitial(this.meminitial);
                ((CompilerJavacLauncher)compiler).setMaxmem(this.maxmem);
            }
            boolean classpathChanged = compiler.setClasspath(this.getClasspath(), this.getMainOutputDirectory(), this.getDirectDependencies());
            boolean sourcesChanged = compiler.setSources(sources);
            if (sourcesChanged || classpathChanged) {
                this.log.info("Compiling {} sources to {}", (Object)sources.size(), (Object)this.getOutputDirectory());
                compiler.compile();
                this.log.info("Compiled {} sources ({} ms)", (Object)sources.size(), (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
            } else {
                compiler.skipCompilation();
                this.log.info("Skipped compilation, all {} sources are up to date", (Object)sources.size());
            }
            this.artifact.setFile(this.getOutputDirectory());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not compile project", (Exception)e);
        }
    }

    private static String getTarget(String target, String source) {
        if (target != null) {
            return target;
        }
        if (source != null) {
            if ("1.2".equals(source) || "1.3".equals(source)) {
                return "1.4";
            }
            return source;
        }
        return DEFAULT_COMPILER_LEVEL;
    }

    private static Set<Debug> parseDebug(String debug) {
        HashSet<Debug> result = new HashSet<Debug>();
        StringTokenizer st = new StringTokenizer(debug, ",");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            Debug keyword = "true".equalsIgnoreCase(token) ? Debug.all : ("false".equalsIgnoreCase(token) ? Debug.none : Debug.valueOf(token));
            result.add(keyword);
        }
        if (result.size() > 1 && (result.contains((Object)Debug.all) || result.contains((Object)Debug.none))) {
            throw new IllegalArgumentException("'all' and 'none' must be used alone: " + debug);
        }
        return result;
    }

    private File mkdirs(File dir) throws MojoExecutionException {
        if (!dir.isDirectory() && !dir.mkdirs()) {
            throw new MojoExecutionException("Could not create directory " + dir);
        }
        return dir;
    }

    public static enum AccessRulesViolation {
        error,
        ignore;

    }

    public static enum Debug {
        all,
        none,
        source,
        lines,
        vars;

    }

    public static enum Proc {
        proc,
        only,
        none;

    }
}

