/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.plugins.compile.javac;

import io.takari.incrementalbuild.BuildContext;
import io.takari.incrementalbuild.spi.DefaultBuildContext;
import io.takari.incrementalbuild.spi.DefaultInput;
import io.takari.maven.plugins.compile.AbstractCompileMojo;
import io.takari.maven.plugins.compile.javac.AbstractCompilerJavac;
import io.takari.maven.plugins.compile.javac.FileObjects;
import io.takari.maven.plugins.compile.javac.ProjectClasspathDigester;
import io.takari.maven.plugins.compile.javac.RecordingJavaFileManager;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.apache.maven.plugin.MojoExecutionException;

@Named(value="javac")
public class CompilerJavac
extends AbstractCompilerJavac {
    public static final String ID = "javac";
    private static final boolean isJava7;
    private static final JavaCompilerFactory REUSECREATED;
    private static final JavaCompilerFactory SINGLETON;

    static {
        boolean isJava7x = true;
        try {
            Class.forName("java.nio.file.Files");
        }
        catch (Exception exception) {
            isJava7x = false;
        }
        isJava7 = isJava7x;
        REUSECREATED = new JavaCompilerFactory(){
            private final Deque<JavaCompiler> compilers = new ArrayDeque<JavaCompiler>();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public JavaCompiler acquire() throws MojoExecutionException {
                Deque<JavaCompiler> deque = this.compilers;
                synchronized (deque) {
                    if (!this.compilers.isEmpty()) {
                        return this.compilers.removeFirst();
                    }
                }
                return CompilerJavac.getSystemJavaCompiler();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void release(JavaCompiler compiler) {
                Deque<JavaCompiler> deque = this.compilers;
                synchronized (deque) {
                    this.compilers.addFirst(compiler);
                }
            }
        };
        SINGLETON = new JavaCompilerFactory(){
            private JavaCompiler compiler;

            @Override
            public void release(JavaCompiler compiler) {
            }

            @Override
            public synchronized JavaCompiler acquire() throws MojoExecutionException {
                if (this.compiler == null) {
                    this.compiler = CompilerJavac.getSystemJavaCompiler();
                }
                return this.compiler;
            }
        };
    }

    static JavaCompiler getSystemJavaCompiler() throws MojoExecutionException {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        if (compiler == null) {
            throw new MojoExecutionException("No compiler is provided in this environment. Perhaps you are running on a JRE rather than a JDK?");
        }
        return compiler;
    }

    @Inject
    public CompilerJavac(DefaultBuildContext<?> context, ProjectClasspathDigester digester) {
        super(context, digester);
    }

    @Override
    public void compile() throws MojoExecutionException, IOException {
        if (!isJava7 && this.getProc() != AbstractCompileMojo.Proc.none) {
            throw new MojoExecutionException("Annotation processing requires forked JVM on Java 6");
        }
        JavaCompilerFactory factory = isJava7 ? SINGLETON : REUSECREATED;
        JavaCompiler compiler = factory.acquire();
        StandardJavaFileManager javaFileManager = compiler.getStandardFileManager(null, null, this.getSourceEncoding());
        try {
            this.compile(compiler, javaFileManager);
        }
        finally {
            javaFileManager.flush();
            javaFileManager.close();
            factory.release(compiler);
        }
    }

    private void compile(JavaCompiler compiler, StandardJavaFileManager javaFileManager) throws IOException {
        this.context.deleteStaleOutputs(false);
        DiagnosticCollector diagnosticCollector = new DiagnosticCollector();
        Iterable<? extends JavaFileObject> javaSources = javaFileManager.getJavaFileObjectsFromFiles(this.getSourceFiles());
        final HashMap looseOutputs = new HashMap();
        final HashMap<File, DefaultInput> inputs = new HashMap<File, DefaultInput>();
        for (JavaFileObject javaFileObject : javaSources) {
            File sourceFile = FileObjects.toFile(javaFileObject);
            inputs.put(sourceFile, this.context.registerInput(sourceFile).process());
        }
        List<String> list = this.getCompilerOptions();
        RecordingJavaFileManager recordingFileManager = new RecordingJavaFileManager(javaFileManager){

            @Override
            protected void record(File inputFile, File outputFile) {
                BuildContext.Input input = (BuildContext.Input)inputs.get(inputFile);
                if (input != null) {
                    input.associateOutput(outputFile);
                } else {
                    looseOutputs.put(outputFile, CompilerJavac.this.context.processOutput(outputFile));
                }
            }
        };
        PrintWriter stdout = new PrintWriter(System.out, true);
        JavaCompiler.CompilationTask task = compiler.getTask(stdout, recordingFileManager, diagnosticCollector, list, null, javaSources);
        boolean success = task.call();
        for (Diagnostic diagnostic : diagnosticCollector.getDiagnostics()) {
            JavaFileObject source = (JavaFileObject)diagnostic.getSource();
            BuildContext.Severity severity = this.toSeverity(diagnostic.getKind(), success);
            String message = diagnostic.getMessage(null);
            if (!this.isShowWarnings() && severity == BuildContext.Severity.WARNING) continue;
            if (source != null) {
                File file = FileObjects.toFile(source);
                if (file != null) {
                    BuildContext.Resource resource = (BuildContext.Resource)inputs.get(file);
                    if (resource == null) {
                        resource = (BuildContext.Resource)looseOutputs.get(file);
                    }
                    if (resource != null) {
                        resource.addMessage((int)diagnostic.getLineNumber(), (int)diagnostic.getColumnNumber(), message, severity, null);
                        continue;
                    }
                    this.log.warn("Unexpected java {} resource {}", (Object)source.getKind(), (Object)source.toUri().toASCIIString());
                    continue;
                }
                this.log.warn("Unsupported compiler message on {} resource {}: {}", new Object[]{source.getKind(), source.toUri(), message});
                continue;
            }
            DefaultInput input = this.context.registerInput(this.getPom()).process();
            input.addMessage(0, 0, message, severity, null);
        }
    }

    private BuildContext.Severity toSeverity(Diagnostic.Kind kind, boolean success) {
        BuildContext.Severity severity;
        if (success && kind == Diagnostic.Kind.ERROR) {
            kind = Diagnostic.Kind.WARNING;
        }
        switch (kind) {
            case ERROR: {
                severity = BuildContext.Severity.ERROR;
                break;
            }
            case NOTE: {
                severity = BuildContext.Severity.INFO;
                break;
            }
            default: {
                severity = BuildContext.Severity.WARNING;
            }
        }
        return severity;
    }

    @Override
    protected String getCompilerId() {
        return ID;
    }

    private static interface JavaCompilerFactory {
        public JavaCompiler acquire() throws MojoExecutionException;

        public void release(JavaCompiler var1);
    }
}

