/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.plugins.compile.javac;

import com.google.common.base.Stopwatch;
import io.takari.incrementalbuild.BuildContext;
import io.takari.incrementalbuild.spi.DefaultBuildContext;
import io.takari.incrementalbuild.spi.ResourceHolder;
import io.takari.maven.plugins.compile.javac.ArtifactFile;
import io.takari.maven.plugins.compile.javac.ArtifactFileHolder;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.scope.MojoExecutionScoped;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.DirectoryScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@MojoExecutionScoped
public class ProjectClasspathDigester {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final Map<File, ArtifactFile> CACHE = new ConcurrentHashMap<File, ArtifactFile>();
    private final DefaultBuildContext<?> context;

    @Inject
    public ProjectClasspathDigester(DefaultBuildContext<?> context, MavenProject project, MavenSession session) {
        this.context = context;
        CACHE.remove(new File(project.getBuild().getOutputDirectory()));
        CACHE.remove(new File(project.getBuild().getTestOutputDirectory()));
    }

    public boolean digestDependencies(List<File> dependencies) throws IOException {
        Stopwatch stopwatch = Stopwatch.createStarted();
        boolean changed = false;
        Map<File, ArtifactFile> previousArtifacts = this.getPreviousDependencies();
        for (File dependency : dependencies) {
            ArtifactFile previousArtifact = previousArtifacts.get(dependency);
            ArtifactFile artifact = CACHE.get(dependency);
            if (artifact == null) {
                if (dependency.isFile()) {
                    artifact = this.newFileArtifact(dependency, previousArtifact);
                } else {
                    if (!dependency.isDirectory()) continue;
                    artifact = this.newDirectoryArtifact(dependency, previousArtifact);
                }
                CACHE.put(dependency, artifact);
            }
            this.context.registerInput((ResourceHolder)new ArtifactFileHolder(artifact));
            if (!this.hasChanged(artifact, previousArtifact)) continue;
            changed = true;
            this.log.debug("New or changed classpath entry {}", (Object)dependency);
        }
        for (BuildContext.InputMetadata removedArtifact : this.context.getRemovedInputs(ArtifactFile.class)) {
            changed = true;
            this.log.debug("Removed classpath entry {}", (Object)((ArtifactFile)removedArtifact.getResource()).file);
        }
        this.log.debug("Analyzed {} classpath dependencies ({} ms)", (Object)dependencies.size(), (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
        return changed;
    }

    private boolean hasChanged(ArtifactFile artifact, ArtifactFile previousArtifact) {
        if (previousArtifact == null) {
            return true;
        }
        return artifact.lastModified != previousArtifact.lastModified || artifact.length != previousArtifact.length;
    }

    private ArtifactFile newDirectoryArtifact(File directory, ArtifactFile previousArtifact) {
        StringBuilder msg = new StringBuilder();
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(directory);
        scanner.setIncludes(new String[]{"**/*.class"});
        scanner.scan();
        long maxLastModified = 0L;
        long fileCount = 0L;
        String[] stringArray = scanner.getIncludedFiles();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            File file = new File(directory, path);
            long lastModified = file.lastModified();
            maxLastModified = Math.max(maxLastModified, lastModified);
            ++fileCount;
            if (previousArtifact != null && previousArtifact.lastModified < lastModified) {
                msg.append("\n   new or modfied class folder member ").append(file);
            }
            ++n2;
        }
        if (previousArtifact != null && previousArtifact.length != fileCount) {
            msg.append("\n   classfolder member count changed (new ").append(fileCount).append(" previous ").append(previousArtifact.length).append(')');
        }
        if (msg.length() > 0) {
            this.log.debug("Changed dependency class folder {}: {}", (Object)directory, (Object)msg.toString());
        }
        return new ArtifactFile(directory, false, fileCount, maxLastModified);
    }

    private ArtifactFile newFileArtifact(File file, ArtifactFile previousArtifact) {
        return new ArtifactFile(file, true, file.length(), file.lastModified());
    }

    private Map<File, ArtifactFile> getPreviousDependencies() {
        HashMap<File, ArtifactFile> result = new HashMap<File, ArtifactFile>();
        for (BuildContext.InputMetadata metadata : this.context.getRegisteredInputs(ArtifactFile.class)) {
            ArtifactFile artifact = (ArtifactFile)metadata.getResource();
            result.put(artifact.file, artifact);
        }
        return result;
    }
}

