/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.plugins.compile.jdt;

import com.google.common.base.Stopwatch;
import io.takari.incrementalbuild.BuildContext;
import io.takari.incrementalbuild.spi.DefaultBuildContext;
import io.takari.incrementalbuild.spi.DefaultInputMetadata;
import io.takari.incrementalbuild.spi.ResourceHolder;
import io.takari.maven.plugins.compile.jdt.ArtifactFile;
import io.takari.maven.plugins.compile.jdt.ArtifactFileHolder;
import io.takari.maven.plugins.compile.jdt.ClassfileDigester;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.scope.MojoExecutionScoped;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.DirectoryScanner;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@MojoExecutionScoped
public class ClasspathDigester {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final Map<File, Map<String, byte[]>> CACHE = new ConcurrentHashMap<File, Map<String, byte[]>>();
    private final DefaultBuildContext<?> context;
    private final ClassfileDigester digester;

    @Inject
    public ClasspathDigester(DefaultBuildContext<?> context, MavenProject project, MavenSession session, ClassfileDigester digester) {
        this.context = context;
        this.digester = digester;
        CACHE.remove(new File(project.getBuild().getOutputDirectory()));
        CACHE.remove(new File(project.getBuild().getTestOutputDirectory()));
    }

    public HashMap<String, byte[]> digestDependencies(List<File> dependencies) throws IOException {
        Stopwatch stopwatch = Stopwatch.createStarted();
        HashMap<String, byte[]> digest = new HashMap<String, byte[]>();
        int i = dependencies.size() - 1;
        while (i >= 0) {
            File file = dependencies.get(i);
            DefaultInputMetadata metadata = this.context.registerInput((ResourceHolder)new ArtifactFileHolder(file));
            if (file.isFile()) {
                digest.putAll(this.digestJar((BuildContext.InputMetadata<ArtifactFile>)metadata));
            } else if (file.isDirectory()) {
                digest.putAll(this.digestDirectory((BuildContext.InputMetadata<ArtifactFile>)metadata));
            }
            --i;
        }
        this.log.debug("Analyzed {} classpath dependencies ({} ms)", (Object)dependencies.size(), (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
        return digest;
    }

    private Map<String, byte[]> digestJar(BuildContext.InputMetadata<ArtifactFile> metadata) throws IOException {
        File file = ((ArtifactFile)metadata.getResource()).file;
        Map<String, byte[]> digest = CACHE.get(file);
        if (digest == null) {
            digest = new HashMap<String, byte[]>();
            try (JarFile jar = new JarFile(file);){
                Enumeration<JarEntry> entries = jar.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    String path = entry.getName();
                    if (!path.endsWith(".class")) continue;
                    String type = ClasspathDigester.toJavaType(path);
                    try {
                        digest.put(type, this.digester.digest((IBinaryType)ClassFileReader.read((ZipFile)jar, (String)path)));
                    }
                    catch (ClassFormatException classFormatException) {}
                }
            }
            CACHE.put(file, digest);
        }
        return digest;
    }

    private Map<String, byte[]> digestDirectory(BuildContext.InputMetadata<ArtifactFile> metadata) throws IOException {
        File directory = ((ArtifactFile)metadata.getResource()).file;
        Map<String, byte[]> digest = CACHE.get(directory);
        if (digest == null) {
            digest = new HashMap<String, byte[]>();
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setBasedir(directory);
            scanner.setIncludes(new String[]{"**/*.class"});
            scanner.scan();
            String[] stringArray = scanner.getIncludedFiles();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                String type = ClasspathDigester.toJavaType(path);
                try {
                    digest.put(type, this.digester.digest((IBinaryType)ClassFileReader.read((File)new File(directory, path))));
                }
                catch (ClassFormatException classFormatException) {}
                ++n2;
            }
            CACHE.put(directory, digest);
        }
        return digest;
    }

    public static String toJavaType(String path) {
        path = path.substring(0, path.length() - ".class".length());
        return path.replace('/', '.').replace('\\', '.');
    }
}

