/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.plugins.compile.jdt;

import com.google.common.base.Stopwatch;
import io.takari.incrementalbuild.BuildContext;
import io.takari.incrementalbuild.spi.DefaultBuildContext;
import io.takari.incrementalbuild.spi.DefaultInput;
import io.takari.incrementalbuild.spi.DefaultInputMetadata;
import io.takari.incrementalbuild.spi.DefaultOutput;
import io.takari.incrementalbuild.spi.DefaultOutputMetadata;
import io.takari.maven.plugins.compile.AbstractCompileMojo;
import io.takari.maven.plugins.compile.AbstractCompiler;
import io.takari.maven.plugins.compile.jdt.AccessRestrictionClasspathEntry;
import io.takari.maven.plugins.compile.jdt.ClassfileDigester;
import io.takari.maven.plugins.compile.jdt.ClasspathDigester;
import io.takari.maven.plugins.compile.jdt.ClasspathEntryCache;
import io.takari.maven.plugins.compile.jdt.CompileQueueClasspathEntry;
import io.takari.maven.plugins.compile.jdt.OutputDirectoryClasspathEntry;
import io.takari.maven.plugins.compile.jdt.ReferenceCollection;
import io.takari.maven.plugins.compile.jdt.classpath.Classpath;
import io.takari.maven.plugins.compile.jdt.classpath.ClasspathEntry;
import io.takari.maven.plugins.compile.jdt.classpath.DependencyClasspathEntry;
import io.takari.maven.plugins.compile.jdt.classpath.JavaInstallation;
import io.takari.maven.plugins.compile.jdt.classpath.MutableClasspathEntry;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.plugin.MojoExecutionException;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.IrritantSet;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblem;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.eclipse.jdt.internal.core.builder.ProblemFactory;

@Named(value="jdt")
public class CompilerJdt
extends AbstractCompiler
implements ICompilerRequestor {
    public static final String ID = "jdt";
    private static final String ATTR_CLASS_DIGEST = "jdt.class.digest";
    private static final String ATTR_CLASSPATH_DIGEST = "jdt.classpath.digest";
    private static final String ATTR_REFERENCES = "jdt.references";
    private Classpath dependencypath;
    private final Set<ICompilationUnit> compileQueue = new LinkedHashSet<ICompilationUnit>();
    private final Set<File> processedSources = new LinkedHashSet<File>();
    private final Set<String> rootNames = new LinkedHashSet<String>();
    private final Set<String> qualifiedNames = new LinkedHashSet<String>();
    private final Set<String> simpleNames = new LinkedHashSet<String>();
    private final ClassfileDigester digester = new ClassfileDigester();
    private final ClasspathEntryCache classpathCache;
    private final ClasspathDigester classpathDigester;

    @Inject
    public CompilerJdt(DefaultBuildContext<?> context, ClasspathEntryCache classpathCache, ClasspathDigester classpathDigester) {
        super(context);
        this.classpathCache = classpathCache;
        this.classpathDigester = classpathDigester;
    }

    @Override
    public void compile() throws MojoExecutionException, IOException {
        IErrorHandlingPolicy errorHandlingPolicy = DefaultErrorHandlingPolicies.exitAfterAllProblems();
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", this.getTarget());
        args.put("org.eclipse.jdt.core.compiler.compliance", this.getTarget());
        args.put("org.eclipse.jdt.core.compiler.source", this.getSource());
        args.put("org.eclipse.jdt.core.compiler.problem.forbiddenReference", "error");
        Set<AbstractCompileMojo.Debug> debug = this.getDebug();
        if (debug == null || debug.contains((Object)AbstractCompileMojo.Debug.all)) {
            args.put("org.eclipse.jdt.core.compiler.debug.localVariable", "generate");
            args.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "generate");
            args.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "generate");
        } else if (debug.contains((Object)AbstractCompileMojo.Debug.none)) {
            args.put("org.eclipse.jdt.core.compiler.debug.localVariable", "do not generate");
            args.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "do not generate");
            args.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "do not generate");
        } else {
            args.put("org.eclipse.jdt.core.compiler.debug.localVariable", "do not generate");
            args.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "do not generate");
            args.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "do not generate");
            for (AbstractCompileMojo.Debug keyword : debug) {
                switch (keyword) {
                    case lines: {
                        args.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "generate");
                        break;
                    }
                    case source: {
                        args.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "generate");
                        break;
                    }
                    case vars: {
                        args.put("org.eclipse.jdt.core.compiler.debug.localVariable", "generate");
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
        }
        class _CompilerOptions
        extends CompilerOptions {
            _CompilerOptions() {
            }

            public void setShowWarnings(boolean showWarnings) {
                this.warningThreshold = showWarnings ? IrritantSet.ALL : new IrritantSet(0);
            }
        }
        _CompilerOptions compilerOptions = new _CompilerOptions();
        compilerOptions.set(args);
        compilerOptions.performMethodsFullRecovery = false;
        compilerOptions.performStatementsRecovery = false;
        compilerOptions.verbose = this.isVerbose();
        compilerOptions.suppressWarnings = true;
        compilerOptions.setShowWarnings(this.isShowWarnings());
        ProblemFactory problemFactory = ProblemFactory.getProblemFactory((Locale)Locale.getDefault());
        Classpath namingEnvironment = this.createClasspath();
        Compiler compiler = new Compiler((INameEnvironment)namingEnvironment, errorHandlingPolicy, (CompilerOptions)compilerOptions, (ICompilerRequestor)this, (IProblemFactory)problemFactory);
        compiler.options.produceReferenceInfo = true;
        while (!this.compileQueue.isEmpty()) {
            ICompilationUnit[] sourceFiles = this.compileQueue.toArray(new ICompilationUnit[this.compileQueue.size()]);
            this.compileQueue.clear();
            compiler.compile(sourceFiles);
            namingEnvironment.reset();
            this.enqueueAffectedSources();
        }
    }

    @Override
    public boolean setSources(List<BuildContext.InputMetadata<File>> sources) throws IOException {
        for (BuildContext.InputMetadata<File> source : sources) {
            if (source.getStatus() == BuildContext.ResourceStatus.UNMODIFIED) continue;
            this.enqueue((File)source.process().getResource());
        }
        for (DefaultOutputMetadata output : this.context.deleteStaleOutputs(false)) {
            this.addDependentsOf(this.getJavaType(output));
        }
        this.enqueueAffectedSources();
        return !this.compileQueue.isEmpty();
    }

    private String getJavaType(DefaultOutputMetadata output) {
        String outputDirectory = this.getOutputDirectory().getAbsolutePath();
        String path = output.getResource().getAbsolutePath();
        if (!path.startsWith(outputDirectory) || !path.endsWith(".class")) {
            return null;
        }
        if ((path = path.substring(outputDirectory.length(), path.length() - ".class".length())).startsWith(File.separator)) {
            path = path.substring(1);
        }
        return path.replace(File.separatorChar, '.');
    }

    private void enqueueAffectedSources() throws IOException {
        for (BuildContext.InputMetadata input : this.context.getRegisteredInputs(File.class)) {
            ReferenceCollection references;
            File resource = (File)input.getResource();
            if (this.processedSources.contains(resource) || !resource.canRead() || (references = (ReferenceCollection)input.getAttribute(ATTR_REFERENCES, ReferenceCollection.class)) == null || !references.includes(this.qualifiedNames, this.simpleNames, this.rootNames)) continue;
            this.enqueue(resource);
        }
        this.qualifiedNames.clear();
        this.simpleNames.clear();
        this.rootNames.clear();
    }

    private void enqueue(File sourceFile) {
        if (this.processedSources.add(sourceFile)) {
            this.compileQueue.add((ICompilationUnit)this.newSourceFile(sourceFile));
        }
    }

    private CompilationUnit newSourceFile(File source) {
        String fileName = source.getAbsolutePath();
        String encoding = this.getSourceEncoding() != null ? this.getSourceEncoding().name() : null;
        return new CompilationUnit(null, fileName, encoding, this.getOutputDirectory().getAbsolutePath(), false);
    }

    private Classpath createClasspath() throws IOException {
        ArrayList<ClasspathEntry> entries = new ArrayList<ClasspathEntry>();
        ArrayList<MutableClasspathEntry> mutableentries = new ArrayList<MutableClasspathEntry>();
        for (File file : JavaInstallation.getDefault().getClasspath()) {
            DependencyClasspathEntry entry = this.classpathCache.get(file);
            if (entry == null) continue;
            entries.add(entry);
        }
        CompileQueueClasspathEntry queueEntry = new CompileQueueClasspathEntry(this.compileQueue);
        entries.add(queueEntry);
        mutableentries.add(queueEntry);
        OutputDirectoryClasspathEntry output = new OutputDirectoryClasspathEntry(this.getOutputDirectory());
        entries.add(output);
        mutableentries.add(output);
        entries.addAll(this.dependencypath.getEntries());
        return new Classpath(entries, mutableentries);
    }

    @Override
    public boolean setClasspath(List<File> dependencies, File mainClasses, Set<File> directDependencies) throws IOException {
        DependencyClasspathEntry entry;
        ArrayList<ClasspathEntry> dependencypath = new ArrayList<ClasspathEntry>();
        ArrayList<File> files = new ArrayList<File>();
        if (mainClasses != null && (entry = this.classpathCache.get(mainClasses)) != null) {
            dependencypath.add(AccessRestrictionClasspathEntry.allowAll(entry));
        }
        for (File dependency : dependencies) {
            DependencyClasspathEntry entry2 = this.classpathCache.get(dependency);
            if (entry2 == null) continue;
            if (this.getTransitiveDependencyReference() == AbstractCompileMojo.AccessRulesViolation.error && !directDependencies.contains(dependency)) {
                dependencypath.add(AccessRestrictionClasspathEntry.forbidAll(entry2));
            } else if (this.getPrivatePackageReference() == AbstractCompileMojo.AccessRulesViolation.ignore) {
                dependencypath.add(AccessRestrictionClasspathEntry.allowAll(entry2));
            } else {
                dependencypath.add(entry2);
            }
            files.add(dependency);
        }
        if (this.log.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder();
            for (ClasspathEntry element : dependencypath) {
                msg.append("\n\u2002\u2002 ").append(element.getEntryDescription());
            }
            this.log.debug("Compile classpath: {} entries{}", (Object)dependencies.size(), (Object)msg.toString());
        }
        this.dependencypath = new Classpath(dependencypath, null);
        Stopwatch stopwatch = Stopwatch.createStarted();
        long typecount = 0L;
        long packagecount = 0L;
        HashMap<String, byte[]> digest = this.classpathDigester.digestDependencies(files);
        DefaultInputMetadata metadata = this.context.registerInput(this.getPom());
        Map oldDigest = (Map)((Object)metadata.getAttribute(ATTR_CLASSPATH_DIGEST, Serializable.class));
        boolean changed = false;
        if (oldDigest != null) {
            HashSet<String> changedPackages = new HashSet<String>();
            for (Map.Entry<String, byte[]> entry3 : digest.entrySet()) {
                String type = entry3.getKey();
                byte[] hash = entry3.getValue();
                if (!Arrays.equals(hash, (byte[])oldDigest.get(type))) {
                    changed = true;
                    this.addDependentsOf(type);
                }
                changedPackages.add(this.getPackage(type));
            }
            for (String oldType : oldDigest.keySet()) {
                if (!digest.containsKey(oldType)) {
                    changed = true;
                    this.addDependentsOf(oldType);
                }
                changedPackages.remove(this.getPackage(oldType));
            }
            for (String changedPackage : changedPackages) {
                this.addDependentsOf(changedPackage);
            }
        } else {
            changed = true;
        }
        if (changed) {
            metadata.process().setAttribute(ATTR_CLASSPATH_DIGEST, digest);
        }
        this.log.debug("Verified {} types and {} packages in {} ms", new Object[]{typecount, packagecount, stopwatch.elapsed(TimeUnit.MILLISECONDS)});
        this.enqueueAffectedSources();
        return !this.compileQueue.isEmpty();
    }

    private String getPackage(String type) {
        int idx = type.lastIndexOf(46);
        return idx > 0 ? type.substring(0, idx) : null;
    }

    public void acceptResult(CompilationResult result) {
        int n;
        int n2;
        CategorizedProblem[] categorizedProblemArray;
        if (result == null) {
            return;
        }
        String sourceName = new String(result.getFileName());
        File sourceFile = new File(sourceName);
        this.processedSources.add(sourceFile);
        DefaultInput input = this.context.registerInput(sourceFile).process();
        input.setAttribute(ATTR_REFERENCES, (Serializable)new ReferenceCollection(result.rootReferences, result.qualifiedReferences, result.simpleNameReferences));
        if (result.hasProblems()) {
            categorizedProblemArray = result.getProblems();
            n2 = categorizedProblemArray.length;
            n = 0;
            while (n < n2) {
                CategorizedProblem problem = categorizedProblemArray[n];
                input.addMessage(problem.getSourceLineNumber(), ((DefaultProblem)problem).column, problem.getMessage(), problem.isError() ? BuildContext.Severity.ERROR : BuildContext.Severity.WARNING, null);
                ++n;
            }
        }
        if (!result.hasErrors()) {
            categorizedProblemArray = result.getClassFiles();
            n2 = categorizedProblemArray.length;
            n = 0;
            while (n < n2) {
                CategorizedProblem classFile = categorizedProblemArray[n];
                try {
                    char[] filename = classFile.fileName();
                    int length = filename.length;
                    char[] relativeName = new char[length + 6];
                    System.arraycopy(filename, 0, relativeName, 0, length);
                    System.arraycopy(SuffixConstants.SUFFIX_class, 0, relativeName, length, 6);
                    CharOperation.replace((char[])relativeName, (char)'/', (char)File.separatorChar);
                    String relativeStringName = new String(relativeName);
                    this.writeClassFile((DefaultInput<File>)input, relativeStringName, (ClassFile)classFile);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                ++n;
            }
        }
    }

    private void writeClassFile(DefaultInput<File> input, String relativeStringName, ClassFile classFile) throws IOException {
        byte[] bytes = classFile.getBytes();
        File outputFile = new File(this.getOutputDirectory(), relativeStringName);
        DefaultOutput output = input.associateOutput(outputFile);
        boolean significantChange = this.digestClassFile(output, bytes);
        if (significantChange) {
            this.addDependentsOf(CharOperation.toString((char[][])classFile.getCompoundName()));
        }
        try (BufferedOutputStream os = new BufferedOutputStream(output.newOutputStream());){
            os.write(bytes);
            os.flush();
        }
    }

    private boolean digestClassFile(DefaultOutput output, byte[] definition) {
        boolean significantChange = true;
        try {
            ClassFileReader reader = new ClassFileReader(definition, output.getResource().getAbsolutePath().toCharArray());
            byte[] hash = this.digester.digest((IBinaryType)reader);
            if (hash != null) {
                byte[] oldHash = (byte[])output.setAttribute(ATTR_CLASS_DIGEST, (Serializable)hash);
                significantChange = oldHash == null || !Arrays.equals(hash, oldHash);
            }
        }
        catch (ClassFormatException classFormatException) {}
        return significantChange;
    }

    private void addDependentsOf(String typeOrPackage) {
        if (typeOrPackage != null) {
            int idx = typeOrPackage.indexOf(46);
            if (idx > 0) {
                this.rootNames.add(typeOrPackage.substring(0, idx));
                idx = typeOrPackage.lastIndexOf(46);
                this.qualifiedNames.add(typeOrPackage.substring(0, idx));
                this.simpleNames.add(typeOrPackage.substring(idx + 1));
            } else {
                this.rootNames.add(typeOrPackage);
                this.simpleNames.add(typeOrPackage);
            }
        }
    }

    @Override
    public void skipCompilation() {
    }
}

