/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.plugins.compile.javac;

import io.takari.incrementalbuild.BuildContext;
import io.takari.maven.plugins.compile.javac.FileObjects;
import io.takari.maven.plugins.compile.javac.RecordingJavaFileManager;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;

public class CompilerJavacForked {
    private static final String EOL = "\n";
    private static final String ENCODING = "UTF-8";

    static Writer newWriter(File file) throws IOException {
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), ENCODING));
    }

    static BufferedReader newBufferedReader(File file) throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), ENCODING));
    }

    public static void main(String[] args) throws IOException {
        CompilerConfiguration config = CompilerConfiguration.read(new File(args[0]));
        try (CompilerOutput output = new CompilerOutput(new File(args[1]));){
            CompilerJavacForked.compile(config, output);
        }
    }

    private static void compile(CompilerConfiguration config, final CompilerOutput output) {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        if (compiler == null) {
            output.addMessage(".", 0, 0, "No compiler is provided in this environment. Perhaps you are running on a JRE rather than a JDK?", Diagnostic.Kind.ERROR);
            return;
        }
        Charset sourceEncoding = config.getSourceEncoding();
        DiagnosticCollector diagnosticCollector = new DiagnosticCollector();
        StandardJavaFileManager standardFileManager = compiler.getStandardFileManager(diagnosticCollector, null, sourceEncoding);
        Iterable<? extends JavaFileObject> fileObjects = standardFileManager.getJavaFileObjectsFromFiles(config.getSources());
        Iterable<String> options = config.getCompilerOptions();
        RecordingJavaFileManager recordingFileManager = new RecordingJavaFileManager(standardFileManager){

            @Override
            protected void record(File inputFile, File outputFile) {
                output.processOutput(inputFile, outputFile);
            }
        };
        PrintWriter stdout = new PrintWriter(System.out, true);
        JavaCompiler.CompilationTask task = compiler.getTask(stdout, recordingFileManager, diagnosticCollector, options, null, fileObjects);
        boolean success = task.call();
        for (Diagnostic diagnostic : diagnosticCollector.getDiagnostics()) {
            JavaFileObject source = (JavaFileObject)diagnostic.getSource();
            Diagnostic.Kind kind = diagnostic.getKind();
            if (success && kind == Diagnostic.Kind.ERROR) {
                kind = Diagnostic.Kind.WARNING;
            }
            if (source != null) {
                File file = FileObjects.toFile(source);
                if (file != null) {
                    output.addMessage(file.getAbsolutePath(), (int)diagnostic.getLineNumber(), (int)diagnostic.getColumnNumber(), diagnostic.getMessage(null), kind);
                    continue;
                }
                output.addLogMessage(String.format("Unsupported compiler message on %s resource %s: %s", new Object[]{source.getKind(), source.toUri(), diagnostic.getMessage(null)}));
                continue;
            }
            output.addMessage(".", 0, 0, diagnostic.getMessage(null), kind);
        }
    }

    public static class CompilerConfiguration {
        private final Charset encoding;
        private final Iterable<String> options;
        private final Iterable<File> sources;

        public CompilerConfiguration(Charset encoding, Iterable<String> options, Iterable<File> sources) {
            this.encoding = encoding;
            this.options = options;
            this.sources = sources;
        }

        public Charset getSourceEncoding() {
            return this.encoding;
        }

        public Iterable<String> getCompilerOptions() {
            return this.options;
        }

        public Iterable<File> getSources() {
            return this.sources;
        }

        public void write(File file) throws IOException {
            try (Writer writer = CompilerJavacForked.newWriter(file);){
                if (this.encoding != null) {
                    writer.write(67);
                    writer.write(this.encoding.name());
                    writer.write(CompilerJavacForked.EOL);
                }
                for (String option : this.options) {
                    writer.write(79);
                    writer.write(option);
                    writer.write(CompilerJavacForked.EOL);
                }
                for (File source : this.sources) {
                    writer.write(83);
                    writer.write(source.getCanonicalPath());
                    writer.write(CompilerJavacForked.EOL);
                }
            }
        }

        public static CompilerConfiguration read(File file) throws IOException {
            Charset encoding = null;
            ArrayList<String> options = new ArrayList<String>();
            ArrayList<File> sources = new ArrayList<File>();
            try (BufferedReader reader = CompilerJavacForked.newBufferedReader(file);){
                String str;
                while ((str = reader.readLine()) != null) {
                    String value = str.substring(1);
                    switch (str.charAt(0)) {
                        case 'C': {
                            encoding = Charset.forName(value);
                            break;
                        }
                        case 'O': {
                            options.add(value);
                            break;
                        }
                        case 'S': {
                            sources.add(new File(value));
                        }
                    }
                }
            }
            return new CompilerConfiguration(encoding, options, sources);
        }
    }

    public static class CompilerOutput {
        private final Writer writer;

        public CompilerOutput(File file) throws IOException {
            this.writer = CompilerJavacForked.newWriter(file);
        }

        public void processOutput(File inputFile, File outputFile) {
            try {
                this.writer.write(79);
                this.writer.write(inputFile != null ? URLEncoder.encode(inputFile.getCanonicalPath(), CompilerJavacForked.ENCODING) : ".");
                this.writer.write(32);
                this.writer.write(URLEncoder.encode(outputFile.getCanonicalPath(), CompilerJavacForked.ENCODING));
                this.writer.write(CompilerJavacForked.EOL);
            }
            catch (IOException e) {
                this.handleException(e);
            }
        }

        public void addMessage(String path, int line, int column, String message, Diagnostic.Kind kind) {
            try {
                this.writer.write(77);
                this.writer.write(URLEncoder.encode(path, CompilerJavacForked.ENCODING));
                this.writer.write(32);
                this.writer.write(Integer.toString(line));
                this.writer.write(32);
                this.writer.write(Integer.toString(column));
                this.writer.write(32);
                switch (kind) {
                    case ERROR: {
                        this.writer.write(69);
                        break;
                    }
                    case NOTE: {
                        this.writer.write(73);
                        break;
                    }
                    default: {
                        this.writer.write(87);
                    }
                }
                this.writer.write(32);
                this.writer.write(URLEncoder.encode(message, CompilerJavacForked.ENCODING));
                this.writer.write(CompilerJavacForked.EOL);
            }
            catch (IOException e) {
                this.handleException(e);
            }
        }

        public void addLogMessage(String message) {
            try {
                this.writer.write(76);
                this.writer.write(message);
                this.writer.write(CompilerJavacForked.EOL);
            }
            catch (IOException e) {
                this.handleException(e);
            }
        }

        public void close() throws IOException {
            this.writer.close();
        }

        private void handleException(IOException e) {
            e.printStackTrace();
            System.exit(1);
        }

        public static void process(File file, CompilerOutputProcessor callback) throws IOException {
            try (BufferedReader reader = CompilerJavacForked.newBufferedReader(file);){
                String str;
                while ((str = reader.readLine()) != null) {
                    String value = str.substring(1);
                    switch (str.charAt(0)) {
                        case 'O': {
                            StringTokenizer st = new StringTokenizer(value, " ");
                            String inputPath = URLDecoder.decode(st.nextToken(), CompilerJavacForked.ENCODING);
                            String outputPath = URLDecoder.decode(st.nextToken(), CompilerJavacForked.ENCODING);
                            callback.processOutput(!".".equals(inputPath) ? new File(inputPath) : null, new File(outputPath));
                            break;
                        }
                        case 'M': {
                            StringTokenizer st = new StringTokenizer(value, " ");
                            String path = URLDecoder.decode(st.nextToken(), CompilerJavacForked.ENCODING);
                            int line = Integer.parseInt(st.nextToken());
                            int column = Integer.parseInt(st.nextToken());
                            BuildContext.Severity severity = CompilerOutput.toSeverity(st.nextToken());
                            String message = URLDecoder.decode(st.nextToken(), CompilerJavacForked.ENCODING);
                            callback.addMessage(path, line, column, message, severity);
                            break;
                        }
                        case 'L': {
                            callback.addLogMessage(value);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException();
                        }
                    }
                }
            }
        }

        private static BuildContext.Severity toSeverity(String token) {
            switch (token) {
                case "E": {
                    return BuildContext.Severity.ERROR;
                }
                case "I": {
                    return BuildContext.Severity.INFO;
                }
            }
            return BuildContext.Severity.WARNING;
        }
    }

    public static interface CompilerOutputProcessor {
        public void processOutput(File var1, File var2);

        public void addMessage(String var1, int var2, int var3, String var4, BuildContext.Severity var5);

        public void addLogMessage(String var1);
    }
}

