/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.plugins.compile;

import com.google.common.base.Charsets;
import com.google.common.base.Stopwatch;
import com.google.common.collect.TreeMultimap;
import com.google.common.io.CharStreams;
import com.google.common.io.Files;
import io.takari.incrementalbuild.Incremental;
import io.takari.incrementalbuild.ResourceMetadata;
import io.takari.maven.plugins.compile.AbstractCompiler;
import io.takari.maven.plugins.compile.CompilerBuildContext;
import io.takari.maven.plugins.compile.javac.CompilerJavacLauncher;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.tools.JavaFileObject;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCompileMojo
extends AbstractMojo {
    private static final String DEFAULT_COMPILER_LEVEL = "1.7";
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Parameter(property="encoding", defaultValue="${project.build.sourceEncoding}")
    private String encoding;
    @Parameter(property="maven.compiler.source", defaultValue="1.7")
    private String source;
    @Parameter(property="maven.compiler.target")
    private String target;
    @Parameter(property="maven.compiler.compilerId", defaultValue="javac")
    protected String compilerId;
    @Parameter(property="maven.compiler.meminitial")
    private String meminitial;
    @Parameter(property="maven.compiler.maxmem")
    private String maxmem;
    @Parameter
    protected Proc proc;
    @Parameter
    protected Boolean lenientProcOnly;
    @Parameter
    protected String[] annotationProcessors;
    @Parameter
    private Map<String, String> annotationProcessorOptions;
    @Parameter(property="maven.compiler.verbose", defaultValue="false")
    private boolean verbose;
    @Parameter(property="maven.compiler.debug", defaultValue="all")
    private String debug;
    @Parameter(property="maven.compiler.showWarnings", defaultValue="false")
    private boolean showWarnings;
    @Parameter(defaultValue="ignore")
    private AccessRulesViolation transitiveDependencyReference;
    @Parameter(defaultValue="ignore")
    private AccessRulesViolation privatePackageReference;
    @Incremental(configuration=Incremental.Configuration.ignore)
    @Parameter(defaultValue="${project.file}", readonly=true)
    private File pom;
    @Incremental(configuration=Incremental.Configuration.ignore)
    @Parameter(defaultValue="${project.basedir}", readonly=true)
    private File basedir;
    @Incremental(configuration=Incremental.Configuration.ignore)
    @Parameter(defaultValue="${project.build.directory}", readonly=true)
    private File buildDirectory;
    @Incremental(configuration=Incremental.Configuration.ignore)
    @Parameter(defaultValue="${plugin.pluginArtifact}", readonly=true)
    private Artifact pluginArtifact;
    @Incremental(configuration=Incremental.Configuration.ignore)
    @Parameter(defaultValue="${project.dependencyArtifacts}", readonly=true)
    private Set<Artifact> directDependencies;
    @Component
    private Map<String, AbstractCompiler> compilers;
    @Component
    private CompilerBuildContext context;

    public Charset getSourceEncoding() {
        return this.encoding == null ? null : Charset.forName(this.encoding);
    }

    private List<ResourceMetadata<File>> getSources() throws IOException, MojoExecutionException {
        ArrayList<ResourceMetadata<File>> sources = new ArrayList<ResourceMetadata<File>>();
        StringBuilder msg = new StringBuilder();
        for (String sourcePath : this.getSourceRoots()) {
            File sourceRoot = new File(sourcePath);
            msg.append("\n").append(sourcePath);
            if (!sourceRoot.isDirectory()) {
                msg.append("\n   does not exist or not a directory, skiped");
                continue;
            }
            Set<String> includes = this.getIncludes();
            if (includes == null || includes.isEmpty()) {
                includes = Collections.singleton("**/*.java");
            } else {
                for (String include : includes) {
                    LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
                    if (!include.endsWith(JavaFileObject.Kind.SOURCE.extension)) {
                        linkedHashSet.add(include);
                    }
                    if (linkedHashSet.isEmpty()) continue;
                    throw new MojoExecutionException(String.format("<includes> patterns must end with %s. Illegal patterns: %s", JavaFileObject.Kind.SOURCE.extension, ((Object)linkedHashSet).toString()));
                }
            }
            Set<String> excludes = this.getExcludes();
            int sourceCount = 0;
            for (ResourceMetadata resourceMetadata : this.context.registerSources(sourceRoot, includes, excludes)) {
                sources.add((ResourceMetadata<File>)resourceMetadata);
                ++sourceCount;
            }
            if (!this.log.isDebugEnabled()) continue;
            msg.append("\n   includes=").append(includes.toString());
            msg.append(" excludes=").append(excludes != null ? excludes.toString() : "[]");
            msg.append(" matched=").append(sourceCount);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Compile source roots:{}", (Object)msg);
        }
        return sources;
    }

    protected Set<File> getDirectDependencies() {
        LinkedHashSet<File> result = new LinkedHashSet<File>();
        for (Artifact artofact : this.directDependencies) {
            result.add(artofact.getFile());
        }
        return result;
    }

    protected abstract Set<String> getSourceRoots();

    protected abstract Set<String> getIncludes();

    protected abstract Set<String> getExcludes();

    protected abstract File getOutputDirectory();

    protected abstract List<File> getClasspath();

    protected abstract File getGeneratedSourcesDirectory();

    protected abstract boolean isSkip();

    protected abstract File getMainOutputDirectory();

    public void execute() throws MojoExecutionException, MojoFailureException {
        Stopwatch stopwatch = Stopwatch.createStarted();
        if (this.isSkip()) {
            this.log.info("Skipping compilation");
            this.context.markSkipExecution();
            return;
        }
        AbstractCompiler compiler = this.compilers.get(this.compilerId);
        if (compiler == null) {
            throw new MojoExecutionException("Unsupported compilerId" + this.compilerId);
        }
        try {
            boolean processorpathChanged;
            List<ResourceMetadata<File>> sources = this.getSources();
            if (sources.isEmpty()) {
                this.log.info("No sources, skipping compilation");
                return;
            }
            this.mkdirs(this.getOutputDirectory());
            List<File> classpath = this.getClasspath();
            Proc proc = this.getEffectiveProc(classpath);
            if (proc != Proc.none) {
                this.mkdirs(this.getGeneratedSourcesDirectory());
            }
            compiler.setOutputDirectory(this.getOutputDirectory());
            compiler.setSource(this.source);
            compiler.setTarget(AbstractCompileMojo.getTarget(this.target, this.source));
            compiler.setProc(proc);
            if (this.lenientProcOnly != null) {
                compiler.setLenientProcOnly(this.lenientProcOnly);
            }
            compiler.setGeneratedSourcesDirectory(this.getGeneratedSourcesDirectory());
            compiler.setAnnotationProcessors(this.annotationProcessors);
            compiler.setAnnotationProcessorOptions(this.annotationProcessorOptions);
            compiler.setVerbose(this.verbose);
            compiler.setPom(this.pom);
            compiler.setSourceEncoding(this.getSourceEncoding());
            compiler.setDebug(AbstractCompileMojo.parseDebug(this.debug));
            compiler.setShowWarnings(this.showWarnings);
            compiler.setTransitiveDependencyReference(this.transitiveDependencyReference);
            compiler.setPrivatePackageReference(this.privatePackageReference);
            if (compiler instanceof CompilerJavacLauncher) {
                ((CompilerJavacLauncher)compiler).setBasedir(this.basedir);
                ((CompilerJavacLauncher)compiler).setJar(this.pluginArtifact.getFile());
                ((CompilerJavacLauncher)compiler).setBuildDirectory(this.buildDirectory);
                ((CompilerJavacLauncher)compiler).setMeminitial(this.meminitial);
                ((CompilerJavacLauncher)compiler).setMaxmem(this.maxmem);
            }
            boolean sourcesChanged = compiler.setSources(sources);
            boolean classpathChanged = compiler.setClasspath(classpath, this.getMainOutputDirectory(), this.getDirectDependencies());
            boolean bl = processorpathChanged = proc != Proc.none ? compiler.setProcessorpath(this.getProcessorpath()) : false;
            if (sourcesChanged || classpathChanged || processorpathChanged) {
                this.log.info("Compiling {} sources to {}", (Object)sources.size(), (Object)this.getOutputDirectory());
                int compiled = compiler.compile();
                this.log.info("Compiled {} out of {} sources ({} ms)", new Object[]{compiled, sources.size(), stopwatch.elapsed(TimeUnit.MILLISECONDS)});
            } else {
                this.log.info("Skipped compilation, all {} classes are up to date", (Object)sources.size());
                this.context.markUptodateExecution();
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not compile project", (Exception)e);
        }
    }

    private Proc getEffectiveProc(List<File> classpath) {
        Proc proc = this.proc;
        if (proc == null) {
            TreeMultimap processors = TreeMultimap.create();
            for (File jar : classpath) {
                if (jar.isFile()) {
                    try {
                        Object object = null;
                        Object var7_8 = null;
                        try (ZipFile zip = new ZipFile(jar);){
                            ZipEntry entry = zip.getEntry("META-INF/services/javax.annotation.processing.Processor");
                            if (entry == null) continue;
                            Throwable throwable = null;
                            Object var11_14 = null;
                            try (InputStreamReader r = new InputStreamReader(zip.getInputStream(entry), Charsets.UTF_8);){
                                processors.putAll((Object)jar, (Iterable)CharStreams.readLines((Readable)r));
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        catch (Throwable throwable) {
                            if (object == null) {
                                object = throwable;
                            } else if (object != throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                            throw object;
                        }
                    }
                    catch (IOException iOException) {}
                    continue;
                }
                if (!jar.isDirectory()) continue;
                try {
                    processors.putAll((Object)jar, (Iterable)Files.readLines((File)new File(jar, "META-INF/services/javax.annotation.processing.Processor"), (Charset)Charsets.UTF_8));
                }
                catch (IOException iOException) {}
            }
            if (!processors.isEmpty()) {
                StringBuilder msg = new StringBuilder("<proc> must be one of 'none', 'only' or 'proc'. Processors found: ");
                for (File jar : processors.keySet()) {
                    msg.append("\n   ").append(jar).append(" ").append(processors.get((Object)jar));
                }
                throw new IllegalArgumentException(msg.toString());
            }
            proc = Proc.none;
        }
        return proc;
    }

    private static String getTarget(String target, String source) {
        if (target != null) {
            return target;
        }
        if (source != null) {
            if ("1.2".equals(source) || "1.3".equals(source)) {
                return "1.4";
            }
            return source;
        }
        return DEFAULT_COMPILER_LEVEL;
    }

    private static Set<Debug> parseDebug(String debug) {
        HashSet<Debug> result = new HashSet<Debug>();
        StringTokenizer st = new StringTokenizer(debug, ",");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            Debug keyword = "true".equalsIgnoreCase(token) ? Debug.all : ("false".equalsIgnoreCase(token) ? Debug.none : Debug.valueOf(token));
            result.add(keyword);
        }
        if (result.size() > 1 && (result.contains((Object)Debug.all) || result.contains((Object)Debug.none))) {
            throw new IllegalArgumentException("'all' and 'none' must be used alone: " + debug);
        }
        return result;
    }

    private File mkdirs(File dir) throws MojoExecutionException {
        if (!dir.isDirectory() && !dir.mkdirs()) {
            throw new MojoExecutionException("Could not create directory " + dir);
        }
        return dir;
    }

    protected List<File> getProcessorpath() {
        return null;
    }

    public static enum AccessRulesViolation {
        error,
        ignore;

    }

    public static enum Debug {
        all,
        none,
        source,
        lines,
        vars;

    }

    public static enum Proc {
        proc,
        only,
        none,
        procEX,
        onlyEX;

    }
}

