/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.plugins.compile.jdt;

import com.google.common.base.Charsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.eclipse.jdt.internal.compiler.classfmt.FieldInfo;
import org.eclipse.jdt.internal.compiler.classfmt.MethodInfo;
import org.eclipse.jdt.internal.compiler.env.ClassSignature;
import org.eclipse.jdt.internal.compiler.env.EnumConstantSignature;
import org.eclipse.jdt.internal.compiler.env.IBinaryAnnotation;
import org.eclipse.jdt.internal.compiler.env.IBinaryElementValuePair;
import org.eclipse.jdt.internal.compiler.env.IBinaryNestedType;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.impl.Constant;

public class ClassfileDigester {
    private final MessageDigest digester;

    public ClassfileDigester() {
        try {
            this.digester = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Unsupported JVM", e);
        }
    }

    public byte[] digest(IBinaryType classFile) {
        char[][][] missingTypes;
        MethodInfo[] methodInfos;
        FieldInfo[] fieldInfos;
        IBinaryNestedType[] memberTypes;
        this.updateInt(classFile.getModifiers());
        long OnlyStructuralTagBits = 27162300892971008L;
        this.updateLong(classFile.getTagBits() & OnlyStructuralTagBits);
        this.updateAnnotations(classFile.getAnnotations());
        this.updateChars(classFile.getGenericSignature());
        this.updateChars(classFile.getSuperclassName());
        char[][] interfacesNames = classFile.getInterfaceNames();
        if (interfacesNames != null) {
            int i = 0;
            while (i < interfacesNames.length) {
                this.updateChars(interfacesNames[i]);
                ++i;
            }
        }
        if ((memberTypes = classFile.getMemberTypes()) != null) {
            int i = 0;
            while (i < memberTypes.length) {
                this.updateChars(memberTypes[i].getName());
                this.updateInt(memberTypes[i].getModifiers());
                ++i;
            }
        }
        if ((fieldInfos = (FieldInfo[])classFile.getFields()) != null) {
            int i = 0;
            while (i < fieldInfos.length) {
                this.updateField(fieldInfos[i]);
                ++i;
            }
        }
        if ((methodInfos = (MethodInfo[])classFile.getMethods()) != null) {
            int i = 0;
            while (i < methodInfos.length) {
                this.updateMethod(methodInfos[i]);
                ++i;
            }
        }
        if ((missingTypes = classFile.getMissingTypeNames()) != null) {
            int i = 0;
            while (i < missingTypes.length) {
                int j = 0;
                while (j < missingTypes[i].length) {
                    if (j > 0) {
                        this.updateChar('.');
                    }
                    this.updateChars(missingTypes[i][j]);
                    ++j;
                }
                ++i;
            }
        }
        return this.digester.digest();
    }

    private void updateMethod(MethodInfo methodInfo) {
        this.updateChars(methodInfo.getGenericSignature());
        this.updateInt(methodInfo.getModifiers());
        this.updateLong(methodInfo.getTagBits() & 0x400000000000L);
        this.updateAnnotations(methodInfo.getAnnotations());
        int i = 0;
        while (i < methodInfo.getAnnotatedParametersCount()) {
            this.updateAnnotations(methodInfo.getParameterAnnotations(i));
            ++i;
        }
        this.updateChars(methodInfo.getSelector());
        this.updateChars(methodInfo.getMethodDescriptor());
        this.updateChars(methodInfo.getGenericSignature());
        char[][] thrownExceptions = methodInfo.getExceptionTypeNames();
        int i2 = 0;
        while (i2 < thrownExceptions.length) {
            this.updateChars(thrownExceptions[i2]);
            ++i2;
        }
    }

    private void updateField(FieldInfo fieldInfo) {
        this.updateChars(fieldInfo.getGenericSignature());
        this.updateInt(fieldInfo.getModifiers());
        this.updateLong(fieldInfo.getTagBits() & 0x400000000000L);
        this.updateAnnotations(fieldInfo.getAnnotations());
        this.updateChars(fieldInfo.getName());
        this.updateChars(fieldInfo.getTypeName());
        this.updateBoolean(fieldInfo.hasConstant());
        if (fieldInfo.hasConstant()) {
            this.updateConstant(fieldInfo.getConstant());
        }
    }

    private void updateConstant(Constant constant) {
        this.updateInt(constant.typeID());
        this.updateString(constant.getClass().getName());
        switch (constant.typeID()) {
            case 10: {
                this.updateInt(constant.intValue());
                break;
            }
            case 3: {
                this.updateByte(constant.byteValue());
                break;
            }
            case 4: {
                this.updateShort(constant.shortValue());
                break;
            }
            case 2: {
                this.updateChar(constant.charValue());
                break;
            }
            case 7: {
                this.updateLong(constant.longValue());
                break;
            }
            case 9: {
                this.updateFloat(constant.floatValue());
                break;
            }
            case 8: {
                this.updateDouble(constant.doubleValue());
                break;
            }
            case 5: {
                this.updateBoolean(constant.booleanValue());
                break;
            }
            case 11: {
                this.updateString(constant.stringValue());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected constant typeID=" + constant.typeID());
            }
        }
    }

    private void updateAnnotations(IBinaryAnnotation[] annotations) {
        if (annotations != null) {
            int i = 0;
            while (i < annotations.length) {
                this.updateAnnotation(annotations[i]);
                ++i;
            }
        }
    }

    private void updateAnnotation(IBinaryAnnotation annotation) {
        this.updateChars(annotation.getTypeName());
        IBinaryElementValuePair[] pairs = annotation.getElementValuePairs();
        int j = 0;
        while (j < pairs.length) {
            this.updateChars(pairs[j].getName());
            Object value = pairs[j].getValue();
            if (value instanceof Object[]) {
                Object[] values = (Object[])value;
                int n = 0;
                while (n < values.length) {
                    this.updateAnnotationValue(values[n]);
                    ++n;
                }
            } else {
                this.updateAnnotationValue(value);
            }
            ++j;
        }
    }

    private void updateAnnotationValue(Object object) {
        if (object instanceof ClassSignature) {
            this.updateChars(((ClassSignature)object).getTypeName());
        } else if (object instanceof Constant) {
            this.updateConstant((Constant)object);
        } else if (object instanceof EnumConstantSignature) {
            this.updateChars(((EnumConstantSignature)object).getTypeName());
            this.updateChars(((EnumConstantSignature)object).getEnumConstantName());
        } else if (object instanceof IBinaryAnnotation) {
            this.updateAnnotation((IBinaryAnnotation)object);
        } else {
            throw new IllegalArgumentException("Unsupported annotation value " + object.toString());
        }
    }

    private void updateLong(long value) {
        byte[] tmp = new byte[]{(byte)(value >> 0 & 0xFFL), (byte)(value >> 8 & 0xFFL), (byte)(value >> 16 & 0xFFL), (byte)(value >> 24 & 0xFFL), (byte)(value >> 32 & 0xFFL), (byte)(value >> 40 & 0xFFL), (byte)(value >> 48 & 0xFFL), (byte)(value >> 56 & 0xFFL)};
        this.digester.update(tmp);
    }

    private void updateInt(int value) {
        byte[] tmp = new byte[]{(byte)(value >> 0 & 0xFF), (byte)(value >> 8 & 0xFF), (byte)(value >> 16 & 0xFF), (byte)(value >> 24 & 0xFF)};
        this.digester.update(tmp);
    }

    private void updateShort(short value) {
        byte[] tmp = new byte[]{(byte)(value >> 0 & 0xFF), (byte)(value >> 8 & 0xFF)};
        this.digester.update(tmp);
    }

    private void updateChars(char[] value) {
        if (value != null) {
            int i = 0;
            while (i < value.length) {
                this.updateChar(value[i]);
                ++i;
            }
        }
    }

    private void updateString(String value) {
        this.digester.update(value.getBytes(Charsets.UTF_8));
    }

    private void updateDouble(double value) {
        this.updateLong(Double.doubleToRawLongBits(value));
    }

    private void updateFloat(float value) {
        this.updateInt(Float.floatToRawIntBits(value));
    }

    private void updateChar(char value) {
        this.updateInt(value);
    }

    private void updateByte(byte value) {
        this.digester.update(value);
    }

    private void updateBoolean(boolean value) {
        this.digester.update(value ? (byte)1 : 0);
    }
}

