/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.plugins.compile.jdt;

import io.takari.maven.plugins.compile.jdt.classpath.ClasspathDirectory;
import io.takari.maven.plugins.compile.jdt.classpath.ClasspathJar;
import io.takari.maven.plugins.compile.jdt.classpath.DependencyClasspathEntry;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Named;

@Named
public class ClasspathEntryCache {
    private static final Map<File, DependencyClasspathEntry> CACHE = new HashMap<File, DependencyClasspathEntry>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DependencyClasspathEntry get(File location) {
        location = this.normalize(location);
        Map<File, DependencyClasspathEntry> map = CACHE;
        synchronized (map) {
            DependencyClasspathEntry entry = null;
            if (!CACHE.containsKey(location)) {
                if (location.isDirectory()) {
                    entry = ClasspathDirectory.create(location);
                } else if (location.isFile()) {
                    try {
                        entry = ClasspathJar.create(location);
                    }
                    catch (IOException iOException) {}
                }
                CACHE.put(location, entry);
            } else {
                entry = CACHE.get(location);
            }
            return entry;
        }
    }

    private File normalize(File location) {
        try {
            location = location.getCanonicalFile();
        }
        catch (IOException iOException) {
            location = location.getAbsoluteFile();
        }
        return location;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flush() {
        Map<File, DependencyClasspathEntry> map = CACHE;
        synchronized (map) {
            CACHE.clear();
        }
    }
}

