/*
 * Decompiled with CFR 0.152.
 */
package io.takari.resources.filtering;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheException;
import com.github.mustachejava.ObjectHandler;
import com.github.mustachejava.reflect.ReflectionObjectHandler;
import com.github.mustachejava.util.GuardException;
import com.github.mustachejava.util.Wrapper;
import com.google.common.io.ByteStreams;
import io.takari.incrementalbuild.BuildContext;
import io.takari.incrementalbuild.Output;
import io.takari.incrementalbuild.Resource;
import io.takari.incrementalbuild.ResourceMetadata;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;

@Named
@Singleton
public class ResourcesProcessor {
    private final BuildContext buildContext;
    private final DefaultMustacheFactory mustacheFactory;

    @Inject
    public ResourcesProcessor(BuildContext buildContext) {
        this.buildContext = buildContext;
        this.mustacheFactory = new NoEncodingMustacheFactory();
        this.mustacheFactory.setObjectHandler((ObjectHandler)new MapReflectionObjectHandler());
    }

    public void process(File sourceDirectory, File targetDirectory, List<String> includes, List<String> excludes) throws IOException {
        for (Resource input : this.buildContext.registerAndProcessInputs(sourceDirectory, includes, excludes)) {
            this.filterResource((Resource<File>)input, sourceDirectory, targetDirectory, null);
        }
    }

    public void process(File sourceDirectory, File targetDirectory, List<String> includes, List<String> excludes, Map<Object, Object> filterProperties) throws IOException {
        for (ResourceMetadata metadata : this.buildContext.registerInputs(sourceDirectory, includes, excludes)) {
            this.filterResource((Resource<File>)metadata.process(), sourceDirectory, targetDirectory, filterProperties);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void filterResource(Resource<File> input, File sourceDirectory, File targetDirectory, Map<Object, Object> filterProperties) throws FileNotFoundException, IOException {
        File outputFile = this.relativize(sourceDirectory, targetDirectory, (File)input.getResource());
        Output output = input.associateOutput(outputFile);
        if (filterProperties != null) {
            Throwable throwable = null;
            Object var8_11 = null;
            try {
                FileReader reader = new FileReader((File)input.getResource());
                try {
                    try (OutputStreamWriter writer = new OutputStreamWriter(output.newOutputStream());){
                        this.filter(reader, writer, filterProperties);
                    }
                    if (reader == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (reader == null) throw throwable;
                    ((Reader)reader).close();
                    throw throwable;
                }
                ((Reader)reader).close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        Throwable throwable = null;
        Object var8_14 = null;
        try {
            FileInputStream is = new FileInputStream((File)input.getResource());
            try {
                try (OutputStream os = output.newOutputStream();){
                    ByteStreams.copy((InputStream)is, (OutputStream)os);
                }
                if (is == null) return;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                if (is == null) throw throwable;
                ((InputStream)is).close();
                throw throwable;
            }
            ((InputStream)is).close();
            return;
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
                throw throwable;
            } else {
                if (throwable == throwable5) throw throwable;
                throwable.addSuppressed(throwable5);
            }
            throw throwable;
        }
    }

    private File relativize(File sourceDirectory, File targetDirectory, File sourceFile) {
        String sourceDir = sourceDirectory.getAbsolutePath();
        String source = sourceFile.getAbsolutePath();
        if (!source.startsWith(sourceDir)) {
            throw new IllegalArgumentException();
        }
        String relative = source.substring(sourceDir.length());
        return new File(targetDirectory, relative);
    }

    public void filter(Reader reader, Writer writer, Map<Object, Object> properties) throws IOException {
        Mustache mustache = this.mustacheFactory.compile(reader, "maven", "${", "}");
        mustache.execute(writer, properties).close();
    }

    private static class MapReflectionObjectHandler
    extends ReflectionObjectHandler {
        private MapReflectionObjectHandler() {
        }

        public Wrapper find(final String name, Object[] scopes) {
            Object[] objectArray = scopes;
            int n = scopes.length;
            int n2 = 0;
            while (n2 < n) {
                final Object scope = objectArray[n2];
                if (scope instanceof Map && ((Map)scope).containsKey(name)) {
                    return new Wrapper(){

                        public Object call(Object[] scopes) throws GuardException {
                            return ((Map)scope).get(name);
                        }
                    };
                }
                ++n2;
            }
            return super.find(name, scopes);
        }

        public String stringify(Object object) {
            if (object instanceof File) {
                return object.toString().replace('\\', '/');
            }
            return object.toString();
        }
    }

    private static class NoEncodingMustacheFactory
    extends DefaultMustacheFactory {
        private NoEncodingMustacheFactory() {
        }

        public void encode(String value, Writer writer) {
            try {
                writer.write(value);
            }
            catch (IOException e) {
                throw new MustacheException((Throwable)e);
            }
        }
    }
}

