/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.plugins.compile.jdt;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.jdt.core.compiler.CharOperation;

public class ReferenceCollection
implements Serializable {
    Set<String> qualifiedNameReferences;
    Set<String> simpleNameReferences;
    Set<String> rootReferences;

    protected ReferenceCollection(char[][] rootReferences, char[][][] qualifiedNameReferences, char[][] simpleNameReferences) {
        this.qualifiedNameReferences = this.toStringSet(qualifiedNameReferences);
        this.simpleNameReferences = this.toStringSet(simpleNameReferences);
        this.rootReferences = this.toStringSet(rootReferences);
    }

    private Set<String> toStringSet(char[][] strings) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        char[][] cArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            char[] string = cArray[n2];
            set.add(new String(string));
            ++n2;
        }
        return set;
    }

    private Set<String> toStringSet(char[][][] arrays) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        char[][][] cArray = arrays;
        int n = arrays.length;
        int n2 = 0;
        while (n2 < n) {
            char[][] array = cArray[n2];
            set.add(CharOperation.toString((char[][])array));
            ++n2;
        }
        return set;
    }

    public boolean includes(Collection<String> qualifiedNames, Collection<String> simpleNames, Collection<String> rootNames) {
        if (rootNames != null) {
            boolean foundRoot = false;
            for (String rootName : rootNames) {
                foundRoot = this.rootReferences.contains(rootName);
                if (foundRoot) break;
            }
            if (!foundRoot) {
                return false;
            }
        }
        for (String simpleName : simpleNames) {
            if (!this.simpleNameReferences.contains(simpleName)) continue;
            for (String qualifiedName : qualifiedNames) {
                if (!(qualifiedName.indexOf(46) > 0 ? this.qualifiedNameReferences.contains(qualifiedName) : this.simpleNameReferences.contains(qualifiedName))) continue;
                return true;
            }
            return false;
        }
        return false;
    }
}

