/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.plugins.compile.jdt.classpath;

import io.takari.maven.plugins.compile.jdt.classpath.ClasspathEntry;
import io.takari.maven.plugins.compile.jdt.classpath.DependencyClasspathEntry;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.osgi.framework.BundleException;

abstract class AbstractClasspathDirectory
extends DependencyClasspathEntry
implements ClasspathEntry {
    protected AbstractClasspathDirectory(File directory) {
        super(directory, AbstractClasspathDirectory.getPackageNames(directory), AbstractClasspathDirectory.getExportedPackages(directory));
    }

    protected static Set<String> getPackageNames(File directory) {
        HashSet<String> packages = new HashSet<String>();
        AbstractClasspathDirectory.populatePackageNames(packages, directory, "");
        return packages;
    }

    private static void populatePackageNames(Set<String> packageNames, File directory, String packageName) {
        File[] files;
        if (!packageName.isEmpty()) {
            packageNames.add(packageName);
        }
        if ((files = directory.listFiles()) != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    AbstractClasspathDirectory.populatePackageNames(packageNames, file, AbstractClasspathDirectory.childPackageName(packageName, file.getName()));
                }
                ++n2;
            }
        }
    }

    private static String childPackageName(String packageName, String childName) {
        return packageName.isEmpty() ? childName : String.valueOf(packageName) + "/" + childName;
    }

    @Override
    public NameEnvironmentAnswer findType(String packageName, String typeName, AccessRestriction accessRestriction) {
        try {
            return this.findType0(packageName, typeName, accessRestriction);
        }
        catch (IOException | ClassFormatException throwable) {
            return null;
        }
    }

    protected abstract NameEnvironmentAnswer findType0(String var1, String var2, AccessRestriction var3) throws IOException, ClassFormatException;

    private static Collection<String> getExportedPackages(File directory) {
        FileInputStream is;
        Object var3_5;
        Throwable throwable;
        Collection<String> exportedPackages = null;
        try {
            throwable = null;
            var3_5 = null;
            try {
                is = new FileInputStream(new File(directory, "META-INF/takari/export-package"));
                try {
                    exportedPackages = AbstractClasspathDirectory.parseExportPackage(is);
                }
                finally {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {}
        if (exportedPackages == null) {
            try {
                throwable = null;
                var3_5 = null;
                try {
                    is = new FileInputStream(new File(directory, "META-INF/MANIFEST.MF"));
                    try {
                        exportedPackages = AbstractClasspathDirectory.parseBundleManifest(is);
                    }
                    finally {
                        if (is != null) {
                            ((InputStream)is).close();
                        }
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (IOException | BundleException throwable4) {}
        }
        return exportedPackages;
    }

    public File getFile(String packageName, String typeName, String suffix) throws IOException {
        String qualifiedFileName = String.valueOf(packageName) + "/" + typeName + suffix;
        File file = new File(this.file, qualifiedFileName).getCanonicalFile();
        if (!file.isFile()) {
            return null;
        }
        if (!file.getPath().replace('\\', '/').endsWith(qualifiedFileName)) {
            return null;
        }
        return file;
    }
}

