/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.plugins.compile;

import com.google.common.base.Strings;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.util.filter.AndDependencyFilter;
import org.eclipse.aether.util.filter.ScopeDependencyFilter;

@Named
class ProcessorpathResolver {
    private final RepositorySystem aether;

    @Inject
    public ProcessorpathResolver(RepositorySystem aether) {
        this.aether = aether;
    }

    public List<File> resolve(RepositorySystemSession session, MavenProject project, List<Dependency> dependencies) throws MojoExecutionException {
        ArtifactTypeRegistry stereotypes = session.getArtifactTypeRegistry();
        CollectRequest collectRequest = new CollectRequest();
        collectRequest.setRootArtifact(RepositoryUtils.toArtifact((Artifact)project.getArtifact()));
        collectRequest.setRequestContext("project");
        collectRequest.setRepositories(project.getRemoteProjectRepositories());
        Map artifacts = project.getArtifactMap();
        for (Dependency dependency : dependencies) {
            Artifact artifact;
            if (Strings.isNullOrEmpty((String)dependency.getVersion()) && (artifact = (Artifact)artifacts.get(ArtifactUtils.versionlessKey((String)dependency.getGroupId(), (String)dependency.getArtifactId()))) != null) {
                dependency = dependency.clone();
                dependency.setVersion(artifact.getVersion());
            }
            collectRequest.addDependency(RepositoryUtils.toDependency((Dependency)dependency, (ArtifactTypeRegistry)stereotypes));
        }
        DependencyManagement depMngt = project.getDependencyManagement();
        if (depMngt != null) {
            for (Dependency dependency : depMngt.getDependencies()) {
                collectRequest.addManagedDependency(RepositoryUtils.toDependency((Dependency)dependency, (ArtifactTypeRegistry)stereotypes));
            }
        }
        ScopeDependencyFilter collectionFilter = new ScopeDependencyFilter(null, Collections.singleton("test"));
        ScopeDependencyFilter resolutionFilter = new ScopeDependencyFilter(null, Collections.singleton("test"));
        resolutionFilter = AndDependencyFilter.newInstance((DependencyFilter)collectionFilter, (DependencyFilter)resolutionFilter);
        DependencyRequest depRequest = new DependencyRequest(collectRequest, (DependencyFilter)resolutionFilter);
        try {
            DependencyNode node = this.aether.collectDependencies(session, collectRequest).getRoot();
            depRequest.setRoot(node);
            ArrayList<File> processorpath = new ArrayList<File>();
            ArrayList errors = new ArrayList();
            for (ArtifactResult artifactResult : this.aether.resolveDependencies(session, depRequest).getArtifactResults()) {
                if (artifactResult.isResolved()) {
                    processorpath.add(artifactResult.getArtifact().getFile());
                    continue;
                }
                errors.addAll(artifactResult.getExceptions());
            }
            if (!errors.isEmpty()) {
                StringBuilder msg = new StringBuilder();
                errors.forEach(e -> {
                    StringBuilder stringBuilder2 = msg.append(e.getMessage()).append(", ");
                });
                throw new MojoExecutionException("Could not resolve processorpath: ");
            }
            return processorpath;
        }
        catch (DependencyCollectionException | DependencyResolutionException e2) {
            throw new MojoExecutionException("Could not resolve processorpath: " + e2.getMessage(), (Exception)e2);
        }
    }
}

