/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.plugins.plugin.model.io.xpp3;

import io.takari.maven.plugins.plugin.model.MojoDescriptor;
import io.takari.maven.plugins.plugin.model.MojoParameter;
import io.takari.maven.plugins.plugin.model.MojoRequirement;
import io.takari.maven.plugins.plugin.model.PluginDependency;
import io.takari.maven.plugins.plugin.model.PluginDescriptor;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.codehaus.plexus.util.xml.pull.MXSerializer;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;

public class PluginDescriptorXpp3Writer {
    private static final String NAMESPACE = null;

    public void write(Writer writer, PluginDescriptor pluginDescriptor) throws IOException {
        MXSerializer serializer = new MXSerializer();
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)"  ");
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", (Object)"\n");
        serializer.setOutput(writer);
        serializer.startDocument(pluginDescriptor.getModelEncoding(), null);
        this.writePluginDescriptor(pluginDescriptor, "mojos", (XmlSerializer)serializer);
        serializer.endDocument();
    }

    public void write(OutputStream stream, PluginDescriptor pluginDescriptor) throws IOException {
        MXSerializer serializer = new MXSerializer();
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)"  ");
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", (Object)"\n");
        serializer.setOutput(stream, pluginDescriptor.getModelEncoding());
        serializer.startDocument(pluginDescriptor.getModelEncoding(), null);
        this.writePluginDescriptor(pluginDescriptor, "mojos", (XmlSerializer)serializer);
        serializer.endDocument();
    }

    private void writeMojoDescriptor(MojoDescriptor mojoDescriptor, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (mojoDescriptor.getSuperclasses() != null && mojoDescriptor.getSuperclasses().size() > 0) {
            serializer.startTag(NAMESPACE, "superclasses");
            for (String string : mojoDescriptor.getSuperclasses()) {
                serializer.startTag(NAMESPACE, "superclasse").text(string).endTag(NAMESPACE, "superclasse");
            }
            serializer.endTag(NAMESPACE, "superclasses");
        }
        if (mojoDescriptor.getGoal() != null) {
            serializer.startTag(NAMESPACE, "goal").text(mojoDescriptor.getGoal()).endTag(NAMESPACE, "goal");
        }
        if (mojoDescriptor.getDescription() != null) {
            serializer.startTag(NAMESPACE, "description").text(mojoDescriptor.getDescription()).endTag(NAMESPACE, "description");
        }
        if (mojoDescriptor.getSince() != null) {
            serializer.startTag(NAMESPACE, "since").text(mojoDescriptor.getSince()).endTag(NAMESPACE, "since");
        }
        if (mojoDescriptor.getRequiresDependencyResolution() != null) {
            serializer.startTag(NAMESPACE, "requiresDependencyResolution").text(mojoDescriptor.getRequiresDependencyResolution()).endTag(NAMESPACE, "requiresDependencyResolution");
        }
        if (mojoDescriptor.getRequiresDependencyCollection() != null) {
            serializer.startTag(NAMESPACE, "requiresDependencyCollection").text(mojoDescriptor.getRequiresDependencyCollection()).endTag(NAMESPACE, "requiresDependencyCollection");
        }
        if (mojoDescriptor.isRequiresDirectInvocation()) {
            serializer.startTag(NAMESPACE, "requiresDirectInvocation").text(String.valueOf(mojoDescriptor.isRequiresDirectInvocation())).endTag(NAMESPACE, "requiresDirectInvocation");
        }
        if (mojoDescriptor.isRequiresProject()) {
            serializer.startTag(NAMESPACE, "requiresProject").text(String.valueOf(mojoDescriptor.isRequiresProject())).endTag(NAMESPACE, "requiresProject");
        }
        if (mojoDescriptor.isRequiresReports()) {
            serializer.startTag(NAMESPACE, "requiresReports").text(String.valueOf(mojoDescriptor.isRequiresReports())).endTag(NAMESPACE, "requiresReports");
        }
        if (mojoDescriptor.isAggregator()) {
            serializer.startTag(NAMESPACE, "aggregator").text(String.valueOf(mojoDescriptor.isAggregator())).endTag(NAMESPACE, "aggregator");
        }
        if (mojoDescriptor.isRequiresOnline()) {
            serializer.startTag(NAMESPACE, "requiresOnline").text(String.valueOf(mojoDescriptor.isRequiresOnline())).endTag(NAMESPACE, "requiresOnline");
        }
        if (mojoDescriptor.isInheritedByDefault()) {
            serializer.startTag(NAMESPACE, "inheritedByDefault").text(String.valueOf(mojoDescriptor.isInheritedByDefault())).endTag(NAMESPACE, "inheritedByDefault");
        }
        if (mojoDescriptor.getPhase() != null) {
            serializer.startTag(NAMESPACE, "phase").text(mojoDescriptor.getPhase()).endTag(NAMESPACE, "phase");
        }
        if (mojoDescriptor.getImplementation() != null) {
            serializer.startTag(NAMESPACE, "implementation").text(mojoDescriptor.getImplementation()).endTag(NAMESPACE, "implementation");
        }
        if (mojoDescriptor.getLanguage() != null) {
            serializer.startTag(NAMESPACE, "language").text(mojoDescriptor.getLanguage()).endTag(NAMESPACE, "language");
        }
        if (mojoDescriptor.getConfigurator() != null) {
            serializer.startTag(NAMESPACE, "configurator").text(mojoDescriptor.getConfigurator()).endTag(NAMESPACE, "configurator");
        }
        if (mojoDescriptor.getInstantiationStrategy() != null) {
            serializer.startTag(NAMESPACE, "instantiationStrategy").text(mojoDescriptor.getInstantiationStrategy()).endTag(NAMESPACE, "instantiationStrategy");
        }
        if (mojoDescriptor.getExecutionStrategy() != null) {
            serializer.startTag(NAMESPACE, "executionStrategy").text(mojoDescriptor.getExecutionStrategy()).endTag(NAMESPACE, "executionStrategy");
        }
        if (mojoDescriptor.isThreadSafe()) {
            serializer.startTag(NAMESPACE, "threadSafe").text(String.valueOf(mojoDescriptor.isThreadSafe())).endTag(NAMESPACE, "threadSafe");
        }
        if (mojoDescriptor.getDeprecated() != null) {
            serializer.startTag(NAMESPACE, "deprecated").text(mojoDescriptor.getDeprecated()).endTag(NAMESPACE, "deprecated");
        }
        if (mojoDescriptor.getParameters() != null && mojoDescriptor.getParameters().size() > 0) {
            serializer.startTag(NAMESPACE, "parameters");
            for (MojoParameter mojoParameter : mojoDescriptor.getParameters()) {
                this.writeMojoParameter(mojoParameter, "parameter", serializer);
            }
            serializer.endTag(NAMESPACE, "parameters");
        }
        if (mojoDescriptor.getRequirements() != null && mojoDescriptor.getRequirements().size() > 0) {
            serializer.startTag(NAMESPACE, "requirements");
            for (MojoRequirement mojoRequirement : mojoDescriptor.getRequirements()) {
                this.writeMojoRequirement(mojoRequirement, "requirement", serializer);
            }
            serializer.endTag(NAMESPACE, "requirements");
        }
        if (mojoDescriptor.isTakariBuilder()) {
            serializer.startTag(NAMESPACE, "takariBuilder").text(String.valueOf(mojoDescriptor.isTakariBuilder())).endTag(NAMESPACE, "takariBuilder");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeMojoParameter(MojoParameter mojoParameter, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (mojoParameter.getName() != null) {
            serializer.startTag(NAMESPACE, "name").text(mojoParameter.getName()).endTag(NAMESPACE, "name");
        }
        if (mojoParameter.getAlias() != null) {
            serializer.startTag(NAMESPACE, "alias").text(mojoParameter.getAlias()).endTag(NAMESPACE, "alias");
        }
        if (mojoParameter.getType() != null) {
            serializer.startTag(NAMESPACE, "type").text(mojoParameter.getType()).endTag(NAMESPACE, "type");
        }
        if (mojoParameter.isRequired()) {
            serializer.startTag(NAMESPACE, "required").text(String.valueOf(mojoParameter.isRequired())).endTag(NAMESPACE, "required");
        }
        if (mojoParameter.isEditable()) {
            serializer.startTag(NAMESPACE, "editable").text(String.valueOf(mojoParameter.isEditable())).endTag(NAMESPACE, "editable");
        }
        if (mojoParameter.getDescription() != null) {
            serializer.startTag(NAMESPACE, "description").text(mojoParameter.getDescription()).endTag(NAMESPACE, "description");
        }
        if (mojoParameter.getDeprecated() != null) {
            serializer.startTag(NAMESPACE, "deprecated").text(mojoParameter.getDeprecated()).endTag(NAMESPACE, "deprecated");
        }
        if (mojoParameter.getSince() != null) {
            serializer.startTag(NAMESPACE, "since").text(mojoParameter.getSince()).endTag(NAMESPACE, "since");
        }
        if (mojoParameter.getImplementation() != null) {
            serializer.startTag(NAMESPACE, "implementation").text(mojoParameter.getImplementation()).endTag(NAMESPACE, "implementation");
        }
        if (mojoParameter.getDefaultValue() != null) {
            serializer.startTag(NAMESPACE, "defaultValue").text(mojoParameter.getDefaultValue()).endTag(NAMESPACE, "defaultValue");
        }
        if (mojoParameter.getExpression() != null) {
            serializer.startTag(NAMESPACE, "expression").text(mojoParameter.getExpression()).endTag(NAMESPACE, "expression");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeMojoRequirement(MojoRequirement mojoRequirement, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (mojoRequirement.getFieldName() != null) {
            serializer.startTag(NAMESPACE, "fieldName").text(mojoRequirement.getFieldName()).endTag(NAMESPACE, "fieldName");
        }
        if (mojoRequirement.getRole() != null) {
            serializer.startTag(NAMESPACE, "role").text(mojoRequirement.getRole()).endTag(NAMESPACE, "role");
        }
        if (mojoRequirement.getRoleHint() != null) {
            serializer.startTag(NAMESPACE, "roleHint").text(mojoRequirement.getRoleHint()).endTag(NAMESPACE, "roleHint");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writePluginDependency(PluginDependency pluginDependency, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (pluginDependency.getGroupId() != null) {
            serializer.startTag(NAMESPACE, "groupId").text(pluginDependency.getGroupId()).endTag(NAMESPACE, "groupId");
        }
        if (pluginDependency.getArtifactId() != null) {
            serializer.startTag(NAMESPACE, "artifactId").text(pluginDependency.getArtifactId()).endTag(NAMESPACE, "artifactId");
        }
        if (pluginDependency.getVersion() != null) {
            serializer.startTag(NAMESPACE, "version").text(pluginDependency.getVersion()).endTag(NAMESPACE, "version");
        }
        if (pluginDependency.getType() != null) {
            serializer.startTag(NAMESPACE, "type").text(pluginDependency.getType()).endTag(NAMESPACE, "type");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writePluginDescriptor(PluginDescriptor pluginDescriptor, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (pluginDescriptor.getMojos() != null && pluginDescriptor.getMojos().size() > 0) {
            for (MojoDescriptor o : pluginDescriptor.getMojos()) {
                this.writeMojoDescriptor(o, "mojo", serializer);
            }
        }
        serializer.endTag(NAMESPACE, tagName);
    }
}

