/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.plugins.compile.jdt;

import io.takari.incrementalbuild.MessageSeverity;
import io.takari.incrementalbuild.Resource;
import io.takari.maven.plugins.compile.CompilerBuildContext;
import java.io.File;
import javax.annotation.processing.Messager;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import org.eclipse.jdt.internal.compiler.apt.dispatch.AptProblem;
import org.eclipse.jdt.internal.compiler.apt.dispatch.BaseMessagerImpl;
import org.eclipse.jdt.internal.compiler.apt.dispatch.BaseProcessingEnvImpl;

class MessagerImpl
extends BaseMessagerImpl
implements Messager {
    private final CompilerBuildContext context;
    private final BaseProcessingEnvImpl _processingEnv;

    public MessagerImpl(CompilerBuildContext context, BaseProcessingEnvImpl _processingEnv) {
        this.context = context;
        this._processingEnv = _processingEnv;
    }

    @Override
    public void printMessage(Diagnostic.Kind kind, CharSequence msg) {
        this.printMessage(kind, msg, null, null, null);
    }

    @Override
    public void printMessage(Diagnostic.Kind kind, CharSequence msg, Element e) {
        this.printMessage(kind, msg, e, null, null);
    }

    @Override
    public void printMessage(Diagnostic.Kind kind, CharSequence msg, Element e, AnnotationMirror a) {
        this.printMessage(kind, msg, e, null, null);
    }

    @Override
    public void printMessage(Diagnostic.Kind kind, CharSequence msg, Element e, AnnotationMirror a, AnnotationValue v) {
        AptProblem problem;
        if (kind == Diagnostic.Kind.ERROR) {
            this._processingEnv.setErrorRaised(true);
        }
        if ((problem = MessagerImpl.createProblem((Diagnostic.Kind)kind, (CharSequence)msg, (Element)e, (AnnotationMirror)a, (AnnotationValue)v)) != null && problem.getOriginatingFileName() != null) {
            Resource<File> input = this.context.getProcessedSource(new File(new String(problem.getOriginatingFileName())));
            input.addMessage(problem.getSourceLineNumber(), problem.getSourceColumnNumber(), problem.getMessage(), this.getSeverity(kind), null);
        } else {
            this.context.addPomMessage(msg.toString(), this.getSeverity(kind), null);
        }
    }

    private MessageSeverity getSeverity(Diagnostic.Kind kind) {
        switch (kind) {
            case ERROR: {
                return MessageSeverity.ERROR;
            }
            case WARNING: 
            case MANDATORY_WARNING: {
                return MessageSeverity.WARNING;
            }
        }
        return MessageSeverity.INFO;
    }
}

