/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.plugins.configurator;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptorBuilder;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;

public class MojoConfigurationProcessor {
    private static final PluginDescriptorBuilder pluginDescriptorBuilder = new PluginDescriptorBuilder();

    public PlexusConfiguration mojoConfigurationFor(Object mojoInstance, PlexusConfiguration pluginConfigurationFromMaven) throws ComponentConfigurationException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStream is = mojoInstance.getClass().getResourceAsStream("/META-INF/maven/plugin.xml");){
                PluginDescriptor pd = pluginDescriptorBuilder.build((Reader)new InputStreamReader(is, StandardCharsets.UTF_8));
                String goal = this.determineGoal(mojoInstance.getClass().getName(), pd);
                PlexusConfiguration defaultMojoConfiguration = pd.getMojo(goal).getMojoConfiguration();
                return this.extractAndMerge(goal, pluginConfigurationFromMaven, defaultMojoConfiguration);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new ComponentConfigurationException((Throwable)e);
        }
    }

    PlexusConfiguration extractAndMerge(String goal, PlexusConfiguration pluginConfigurationFromMaven, PlexusConfiguration defaultMojoConfiguration) throws ComponentConfigurationException {
        XmlPlexusConfiguration mojoConfigurationFromPom = new XmlPlexusConfiguration("configuration");
        PlexusConfiguration[] plexusConfigurationArray = pluginConfigurationFromMaven.getChildren();
        int n = plexusConfigurationArray.length;
        int n2 = 0;
        while (n2 < n) {
            PlexusConfiguration element = plexusConfigurationArray[n2];
            if (element.getName().equals(goal)) {
                PlexusConfiguration[] plexusConfigurationArray2 = element.getChildren();
                int n3 = plexusConfigurationArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    PlexusConfiguration goalConfigurationElements = plexusConfigurationArray2[n4];
                    mojoConfigurationFromPom.addChild(goalConfigurationElements);
                    ++n4;
                }
            }
            ++n2;
        }
        return new XmlPlexusConfiguration(Xpp3Dom.mergeXpp3Dom((Xpp3Dom)this.convert((PlexusConfiguration)mojoConfigurationFromPom), (Xpp3Dom)this.convert(defaultMojoConfiguration)));
    }

    PlexusConfiguration mergePlexusConfiguration(PlexusConfiguration dominant, PlexusConfiguration recessive) throws ComponentConfigurationException {
        return new XmlPlexusConfiguration(Xpp3Dom.mergeXpp3Dom((Xpp3Dom)this.convert(dominant), (Xpp3Dom)this.convert(recessive)));
    }

    Xpp3Dom convert(PlexusConfiguration c) throws ComponentConfigurationException {
        try {
            return Xpp3DomBuilder.build((Reader)new StringReader(c.toString()));
        }
        catch (Exception e) {
            throw new ComponentConfigurationException("Failure converting PlexusConfiguration to Xpp3Dom.", (Throwable)e);
        }
    }

    String determineGoal(String className, PluginDescriptor pluginDescriptor) throws ComponentConfigurationException {
        List mojos = pluginDescriptor.getMojos();
        for (MojoDescriptor mojo : mojos) {
            if (!className.equals(mojo.getImplementation())) continue;
            return mojo.getGoal();
        }
        throw new ComponentConfigurationException("Cannot find the goal implementation with " + className);
    }
}

