/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.plugins;

import io.takari.incrementalbuild.Incremental;
import java.io.File;
import java.util.List;
import javax.inject.Inject;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.settings.Settings;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TakariLifecycleMojo
extends AbstractMojo {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Inject
    protected RepositorySystem repositorySystem;
    @Inject
    protected MavenProjectHelper projectHelper;
    @Incremental(configuration=Incremental.Configuration.ignore)
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Incremental(configuration=Incremental.Configuration.ignore)
    @Parameter(defaultValue="${session}")
    private MavenSession session;
    @Incremental(configuration=Incremental.Configuration.ignore)
    @Parameter(defaultValue="${reactorProjects}", readonly=true)
    protected List<MavenProject> reactorProjects;
    @Incremental(configuration=Incremental.Configuration.ignore)
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    protected RepositorySystemSession repositorySystemSession;
    @Incremental(configuration=Incremental.Configuration.ignore)
    @Parameter(defaultValue="${project.remoteRepositories}", readonly=true)
    protected List<RemoteRepository> remoteRepositories;
    @Incremental(configuration=Incremental.Configuration.ignore)
    @Parameter(defaultValue="${mojoExecution}", readonly=true)
    protected MojoExecution mojoExecution;
    @Incremental(configuration=Incremental.Configuration.ignore)
    @Parameter(defaultValue="${mojoExecution.mojoDescriptor}", readonly=true)
    protected MojoDescriptor mojoDescriptor;
    @Incremental(configuration=Incremental.Configuration.ignore)
    @Parameter(defaultValue="${settings}", readonly=true)
    protected Settings settings;
    @Incremental(configuration=Incremental.Configuration.ignore)
    @Parameter(defaultValue="false", property="skip")
    protected boolean skip;

    protected abstract void executeMojo() throws MojoExecutionException;

    protected void skipMojo() throws MojoExecutionException {
    }

    public final void execute() throws MojoExecutionException {
        if (this.skip) {
            this.logger.info(String.format("Skipping %s goal", this.mojoDescriptor.getGoal()));
            this.skipMojo();
            return;
        }
        this.executeMojo();
    }

    protected boolean alternateLifecycleProvidingPrimaryArtifact() {
        String alternateLifecycleProvidingPrimaryArtifact = this.session.getUserProperties().getProperty("@ALTERNATE_LIFECYCLE_PROVIDING_PRIMARY_ARTIFACT@");
        return alternateLifecycleProvidingPrimaryArtifact != null && alternateLifecycleProvidingPrimaryArtifact.equals("true");
    }

    protected boolean isFile(File file) {
        return file != null && file.isFile();
    }
}

