/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.plugins.compile.javac;

import io.takari.incrementalbuild.Resource;
import io.takari.incrementalbuild.ResourceMetadata;
import io.takari.incrementalbuild.ResourceStatus;
import io.takari.maven.plugins.compile.AbstractCompileMojo;
import io.takari.maven.plugins.compile.AbstractCompiler;
import io.takari.maven.plugins.compile.CompilerBuildContext;
import io.takari.maven.plugins.compile.ProjectClasspathDigester;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.languages.java.version.JavaVersion;

public abstract class AbstractCompilerJavac
extends AbstractCompiler {
    protected static final boolean isJava8orBetter;
    private final ProjectClasspathDigester digester;
    private final List<ResourceMetadata<File>> sources = new ArrayList<ResourceMetadata<File>>();
    private String classpath;
    private String sourcepath = "";
    private String processorpath;

    static {
        boolean _isJava8orBetter = true;
        try {
            Class.forName("java.util.Base64");
        }
        catch (Exception exception) {
            _isJava8orBetter = false;
        }
        isJava8orBetter = _isJava8orBetter;
    }

    protected AbstractCompilerJavac(CompilerBuildContext context, ProjectClasspathDigester digester) {
        super(context);
        this.digester = digester;
    }

    protected List<String> getCompilerOptions() {
        Set<AbstractCompileMojo.Debug> debug;
        ArrayList<String> options = new ArrayList<String>();
        options.add("-d");
        options.add(this.getOutputDirectory().getAbsolutePath());
        if (this.getRelease() != null && JavaVersion.JAVA_VERSION.isAtLeast("9")) {
            options.add("--release");
            options.add(this.getRelease());
        } else {
            options.add("-source");
            options.add(this.getSource());
            if (this.getTarget() != null) {
                options.add("-target");
                options.add(this.getTarget());
            }
        }
        options.add("-classpath");
        options.add(this.classpath);
        options.add("-Xprefer:source");
        options.add("-sourcepath");
        options.add(this.sourcepath);
        options.add("-implicit:none");
        switch (this.getProc()) {
            case only: {
                options.add("-proc:only");
                break;
            }
            case proc: {
                options.add("-proc:full");
                break;
            }
            case none: {
                options.add("-proc:none");
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        if (this.getProc() != AbstractCompileMojo.Proc.none) {
            options.add("-s");
            options.add(this.getGeneratedSourcesDirectory().getAbsolutePath());
            if (this.processorpath != null) {
                options.add("-processorpath");
                options.add(this.processorpath);
            }
            if (this.getAnnotationProcessors() != null) {
                options.add("-processor");
                StringBuilder processors = new StringBuilder();
                String[] stringArray = this.getAnnotationProcessors();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String processor = stringArray[n2];
                    if (processors.length() > 0) {
                        processors.append(',');
                    }
                    processors.append(processor);
                    ++n2;
                }
                options.add(processors.toString());
            }
            if (this.getAnnotationProcessorOptions() != null) {
                for (Map.Entry<String, String> option : this.getAnnotationProcessorOptions().entrySet()) {
                    options.add("-A" + option.getKey() + "=" + option.getValue());
                }
            }
        }
        if (this.isVerbose()) {
            options.add("-verbose");
        }
        if (this.isParameters()) {
            options.add("-parameters");
        }
        if ((debug = this.getDebug()) == null || debug.contains((Object)AbstractCompileMojo.Debug.all)) {
            options.add("-g");
        } else if (debug.contains((Object)AbstractCompileMojo.Debug.none)) {
            options.add("-g:none");
        } else {
            StringBuilder keywords = new StringBuilder();
            for (AbstractCompileMojo.Debug keyword : debug) {
                if (keywords.length() > 0) {
                    keywords.append(',');
                }
                keywords.append(keyword.name());
            }
            options.add("-g:" + String.valueOf(keywords));
        }
        if (this.isShowWarnings()) {
            options.add("-Xlint:all");
        } else {
            options.add("-Xlint:none");
        }
        return options;
    }

    @Override
    public boolean setClasspath(List<File> dependencies, File mainClasses, Set<File> directDependencies) throws IOException {
        ArrayList<File> classpath = new ArrayList<File>();
        if (mainClasses != null) {
            classpath.add(mainClasses);
        }
        classpath.addAll(dependencies);
        if (this.log.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder();
            for (File element : classpath) {
                msg.append("\n\u2002\u2002 ").append(element);
            }
            this.log.debug("Compile classpath: {} entries{}", (Object)classpath.size(), (Object)msg);
        }
        StringBuilder cp = new StringBuilder();
        cp.append(this.getOutputDirectory().getAbsolutePath());
        for (File dependency : classpath) {
            if (dependency == null) continue;
            cp.append(File.pathSeparatorChar).append(dependency.getAbsolutePath());
        }
        this.classpath = cp.toString();
        return this.digester.digestClasspath(classpath);
    }

    @Override
    public boolean setSourcepath(List<File> dependencies, Set<File> sourceRoots) throws IOException {
        StringBuilder cp = new StringBuilder();
        for (File dependency : dependencies) {
            if (dependency == null) continue;
            cp.append(File.pathSeparatorChar).append(dependency.getAbsolutePath());
        }
        this.sourcepath = cp.toString();
        return this.digester.digestSourcepath(dependencies);
    }

    @Override
    public boolean setSources(List<ResourceMetadata<File>> sources) {
        this.sources.addAll(sources);
        ArrayList<ResourceMetadata<File>> modifiedSources = new ArrayList<ResourceMetadata<File>>();
        ArrayList<ResourceMetadata<File>> inputs = new ArrayList<ResourceMetadata<File>>();
        for (ResourceMetadata<File> input : sources) {
            inputs.add(input);
            if (input.getStatus() == ResourceStatus.UNMODIFIED) continue;
            modifiedSources.add(input);
        }
        Collection<ResourceMetadata<File>> deletedSources = this.context.getRemovedSources();
        if (!this.context.isEscalated() && this.log.isDebugEnabled()) {
            StringBuilder inputsMsg = new StringBuilder("Modified inputs:");
            for (ResourceMetadata resourceMetadata : modifiedSources) {
                inputsMsg.append("\n   ").append(resourceMetadata.getStatus()).append(" ").append(resourceMetadata.getResource());
            }
            for (ResourceMetadata resourceMetadata : deletedSources) {
                inputsMsg.append("\n   ").append(resourceMetadata.getStatus()).append(" ").append(resourceMetadata.getResource());
            }
            this.log.debug(inputsMsg.toString());
        }
        return !modifiedSources.isEmpty() || !deletedSources.isEmpty();
    }

    @Override
    public void setPrivatePackageReference(AbstractCompileMojo.AccessRulesViolation accessRulesViolation) {
        if (accessRulesViolation == AbstractCompileMojo.AccessRulesViolation.error) {
            String msg = String.format("Compiler %s does not support privatePackageReference=error, use compilerId=%s", this.getCompilerId(), "jdt");
            throw new IllegalArgumentException(msg);
        }
    }

    @Override
    public void setTransitiveDependencyReference(AbstractCompileMojo.AccessRulesViolation accessRulesViolation) {
        if (accessRulesViolation == AbstractCompileMojo.AccessRulesViolation.error) {
            String msg = String.format("Compiler %s does not support transitiveDependencyReference=error, use compilerId=%s", this.getCompilerId(), "jdt");
            throw new IllegalArgumentException(msg);
        }
    }

    @Override
    public boolean setProcessorpath(List<File> processorpath) throws IOException {
        if (processorpath != null) {
            if (this.log.isDebugEnabled()) {
                StringBuilder msg = new StringBuilder();
                for (File element : processorpath) {
                    msg.append("\n\u2002\u2002 ").append(element);
                }
                this.log.debug("Processorpath: {} entries{}", (Object)processorpath.size(), (Object)msg);
            }
            this.processorpath = processorpath.stream().map(File::toString).collect(Collectors.joining(File.pathSeparator));
        }
        return this.digester.digestProcessorpath(processorpath != null ? processorpath : Collections.emptyList());
    }

    @Override
    public final int compile() throws MojoExecutionException, IOException {
        this.context.deleteOutputs();
        LinkedHashMap<File, Resource<File>> files = new LinkedHashMap<File, Resource<File>>(this.sources.size());
        for (ResourceMetadata<File> input : this.sources) {
            files.put((File)input.getResource(), (Resource<File>)input.process());
        }
        return this.compile(files);
    }

    protected abstract int compile(Map<File, Resource<File>> var1) throws MojoExecutionException, IOException;

    protected abstract String getCompilerId();
}

