/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.plugins.compile.javac;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;

class IncrementalFileOutputStream
extends OutputStream {
    public static final int BUF_SIZE = 16384;
    private final RandomAccessFile raf;
    private final byte[] buffer;
    private boolean modified;

    public IncrementalFileOutputStream(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("output file not specified");
        }
        File parent = file.getParentFile();
        if (!parent.isDirectory() && !parent.mkdirs()) {
            throw new IOException("Could not create directory " + String.valueOf(parent));
        }
        boolean bl = this.modified = !file.exists();
        if (file.exists() && !file.canWrite()) {
            file.setWritable(true);
        }
        this.raf = new RandomAccessFile(file, "rw");
        this.buffer = new byte[16384];
    }

    @Override
    public void close() throws IOException {
        long pos = this.raf.getFilePointer();
        if (pos < this.raf.length()) {
            this.modified = true;
            this.raf.setLength(pos);
        }
        this.raf.close();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.modified) {
            this.raf.write(b, off, len);
        } else {
            int n = len;
            while (n > 0) {
                int read = this.raf.read(this.buffer, 0, Math.min(this.buffer.length, n));
                if (read < 0 || !this.arrayEquals(b, off + len - n, this.buffer, 0, read)) {
                    this.modified = true;
                    if (read > 0) {
                        this.raf.seek(this.raf.getFilePointer() - (long)read);
                    }
                    this.raf.write(b, off + len - n, n);
                    break;
                }
                n -= read;
            }
        }
    }

    private boolean arrayEquals(byte[] a1, int off1, byte[] a2, int off2, int len) {
        int i = 0;
        while (i < len) {
            if (a1[off1 + i] != a2[off2 + i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.modified) {
            this.raf.write(b);
        } else {
            int i = this.raf.read();
            if (i < 0 || i != (b & 0xFF)) {
                this.modified = true;
                if (i >= 0) {
                    this.raf.seek(this.raf.getFilePointer() - 1L);
                }
                this.raf.write(b);
            }
        }
    }
}

