/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.plugins.compile.jdt;

import io.takari.incrementalbuild.MessageSeverity;
import io.takari.maven.plugins.compile.CompilerBuildContext;
import io.takari.maven.plugins.compile.jdt.CompilerJdt;
import io.takari.maven.plugins.compile.jdt.FilerImpl;
import io.takari.maven.plugins.compile.jdt.ProcessingEnvImpl;
import io.takari.maven.plugins.compile.jdt.ReferenceCollection;
import java.io.File;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import org.eclipse.jdt.internal.compiler.apt.dispatch.BaseAnnotationProcessorManager;
import org.eclipse.jdt.internal.compiler.apt.dispatch.BaseProcessingEnvImpl;
import org.eclipse.jdt.internal.compiler.apt.dispatch.IProcessorProvider;
import org.eclipse.jdt.internal.compiler.apt.dispatch.ProcessorInfo;
import org.eclipse.jdt.internal.compiler.apt.dispatch.RoundDispatcher;
import org.eclipse.jdt.internal.compiler.apt.dispatch.RoundEnvImpl;
import org.eclipse.jdt.internal.compiler.apt.model.ElementImpl;
import org.eclipse.jdt.internal.compiler.apt.model.TypeElementImpl;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;

class AnnotationProcessorManager
extends BaseAnnotationProcessorManager {
    private final CompilerBuildContext context;
    private final Set<File> processedSources = new LinkedHashSet<File>();
    private boolean recordingReferencedTypes = true;
    private final Set<String> referencedTypes = new LinkedHashSet<String>();
    private boolean suppressRegularRounds = false;
    private boolean suppressLastRound = false;
    private final Iterator<Processor> processors;
    private final CompilerJdt incrementalCompiler;

    public AnnotationProcessorManager(CompilerBuildContext context, ProcessingEnvImpl processingEnv, StandardJavaFileManager fileManager, String[] processors, CompilerJdt incrementalCompiler) {
        this.context = context;
        this._processingEnv = processingEnv;
        this.incrementalCompiler = incrementalCompiler;
        ClassLoader procLoader = fileManager.getClassLoader(StandardLocation.ANNOTATION_PROCESSOR_PATH);
        this.processors = processors != null ? new SpecifiedProcessors(procLoader, processors) : new DiscoveredProcessors(procLoader);
        processingEnv.addReferencedTypeObserver(this::recordReferencedType);
    }

    private void recordReferencedType(String type) {
        if (this.recordingReferencedTypes) {
            this.referencedTypes.add(type);
        }
    }

    public ProcessorInfo discoverNextProcessor() {
        if (this.processors.hasNext()) {
            Processor processor = this.processors.next();
            processor.init((ProcessingEnvironment)this._processingEnv);
            ProcessorInfo procecssorInfo = new ProcessorInfo(processor){

                public boolean computeSupportedAnnotations(Set<TypeElement> annotations, Set<TypeElement> result) {
                    boolean shouldCall = super.computeSupportedAnnotations(annotations, result);
                    if (shouldCall) {
                        AnnotationProcessorManager.this.incrementalCompiler.onAnnotationProcessing();
                    }
                    return shouldCall;
                }
            };
            this._processors.add(procecssorInfo);
            return procecssorInfo;
        }
        return null;
    }

    public void reportProcessorException(Processor p, Exception e) {
        String msg = String.format("Exception executing annotation processor %s: %s", p.getClass().getName(), e.getMessage());
        this.context.addPomMessage(msg, MessageSeverity.ERROR, e);
        throw new AbortCompilation(null, (Throwable)e);
    }

    public void incrementalIterationReset() {
        ((ProcessingEnvImpl)this._processingEnv).incrementalIterationReset();
    }

    public void processAnnotations(CompilationUnitDeclaration[] units, ReferenceBinding[] referenceBindings, boolean isLastRound) {
        PrintWriter traceRounds;
        if (!isLastRound && this.suppressRegularRounds) {
            return;
        }
        if (isLastRound && this.suppressLastRound) {
            return;
        }
        _RoundEnvImpl roundEnv = new _RoundEnvImpl(units, referenceBindings, isLastRound, this._processingEnv);
        if (this._isFirstRound) {
            this._isFirstRound = false;
        }
        PrintWriter traceProcessorInfo = this._printProcessorInfo ? this._out : null;
        PrintWriter printWriter = traceRounds = this._printRounds ? this._out : null;
        if (traceRounds != null) {
            traceRounds.println("Round " + ++this._round + ":");
        }
        RoundDispatcher dispatcher = new RoundDispatcher((IProcessorProvider)this, (RoundEnvironment)((Object)roundEnv), roundEnv.getRootAnnotations(), traceProcessorInfo, traceRounds);
        dispatcher.round();
    }

    public void suppressRegularRounds(boolean suppress) {
        this.suppressRegularRounds = suppress;
    }

    public void suppressLastRound(boolean suppress) {
        this.suppressLastRound = suppress;
    }

    public Set<File> getProcessedSources() {
        return Collections.unmodifiableSet(new LinkedHashSet<File>(this.processedSources));
    }

    public ReferenceCollection getReferencedTypes() {
        ReferenceCollection references = new ReferenceCollection();
        references.addDependencies(this.referencedTypes);
        return references;
    }

    public Set<File> getWittenOutputs() {
        return ((FilerImpl)this._processingEnv.getFiler()).getWrittenFiles();
    }

    private static class DiscoveredProcessors
    implements Iterator<Processor> {
        private final ServiceLoader<Processor> loader;
        private final Iterator<Processor> iterator;

        public DiscoveredProcessors(ClassLoader procLoader) {
            this.loader = ServiceLoader.load(Processor.class, procLoader);
            this.iterator = this.loader.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Processor next() {
            return this.iterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class SpecifiedProcessors
    implements Iterator<Processor> {
        private final ClassLoader loader;
        private final String[] processors;
        private int idx;

        public SpecifiedProcessors(ClassLoader loader, String[] processors) {
            this.loader = loader;
            this.processors = processors;
        }

        @Override
        public boolean hasNext() {
            return this.idx < this.processors.length;
        }

        @Override
        public Processor next() {
            try {
                return (Processor)this.loader.loadClass(this.processors[this.idx++]).newInstance();
            }
            catch (ReflectiveOperationException e) {
                throw new AbortCompilation(null, (Throwable)e);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class _RoundEnvImpl
    extends RoundEnvImpl {
        public _RoundEnvImpl(CompilationUnitDeclaration[] units, ReferenceBinding[] binaryTypeBindings, boolean isLastRound, BaseProcessingEnvImpl env) {
            super(units, binaryTypeBindings, isLastRound, env);
        }

        public Set<? extends Element> getElementsAnnotatedWith(TypeElement a) {
            return this.recordProcessedSources(() -> super.getElementsAnnotatedWith(a));
        }

        public Set<? extends Element> getRootElements() {
            return this.recordProcessedSources(() -> super.getRootElements());
        }

        private Set<? extends Element> recordProcessedSources(Supplier<Set<? extends Element>> elementsSupplier) {
            boolean _recordingReferencedTypes = AnnotationProcessorManager.this.recordingReferencedTypes;
            try {
                AnnotationProcessorManager.this.recordingReferencedTypes = false;
                Set<? extends Element> elements = elementsSupplier.get();
                if (_recordingReferencedTypes) {
                    for (Element element : elements) {
                        File sourceFile = this.getSourceFile((ElementImpl)element);
                        if (sourceFile == null) continue;
                        AnnotationProcessorManager.this.processedSources.add(sourceFile);
                    }
                }
                Set<? extends Element> set = elements;
                return set;
            }
            finally {
                AnnotationProcessorManager.this.recordingReferencedTypes = _recordingReferencedTypes;
            }
        }

        private File getSourceFile(ElementImpl element) {
            TypeElementImpl topLevelType = this.getTopLevelType(element);
            if (topLevelType == null) {
                return null;
            }
            Binding binding = topLevelType._binding;
            if (binding instanceof SourceTypeBinding) {
                return new File(new String(((SourceTypeBinding)binding).getFileName()));
            }
            return null;
        }

        private TypeElementImpl getTopLevelType(ElementImpl element) {
            while (element != null) {
                if (element instanceof TypeElementImpl && ((TypeElementImpl)element).getNestingKind() == NestingKind.TOP_LEVEL) {
                    return (TypeElementImpl)element;
                }
                element = (ElementImpl)element.getEnclosingElement();
            }
            return null;
        }
    }
}

