/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.plugins.compile.jdt;

import io.takari.maven.plugins.compile.jdt.classpath.ClasspathDirectory;
import io.takari.maven.plugins.compile.jdt.classpath.ClasspathEntry;
import io.takari.maven.plugins.compile.jdt.classpath.MutableClasspathEntry;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;

class OutputDirectoryClasspathEntry
implements ClasspathEntry,
MutableClasspathEntry {
    private final File directory;
    private final Collection<File> staleOutputs;
    private ClasspathDirectory delegate;

    public OutputDirectoryClasspathEntry(File directory, Collection<File> staleOutputs) {
        this.directory = directory;
        this.staleOutputs = staleOutputs;
        this.delegate = ClasspathDirectory.create(directory.toPath());
    }

    @Override
    public Collection<String> getPackageNames() {
        return this.delegate.getPackageNames();
    }

    @Override
    public NameEnvironmentAnswer findType(String packageName, String typeName) {
        Path file = this.delegate.getFile(packageName, typeName);
        if (file != null && !this.staleOutputs.contains(file.toFile())) {
            return this.delegate.findType(packageName, typeName, null);
        }
        return null;
    }

    @Override
    public void reset() {
        this.delegate = ClasspathDirectory.create(this.directory.toPath());
    }

    public String toString() {
        return "Classpath for output directory " + String.valueOf(this.directory);
    }

    @Override
    public String getEntryDescription() {
        return this.directory.getAbsolutePath();
    }
}

