/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.plugins.compile.jdt.classpath;

import io.takari.maven.plugins.compile.jdt.classpath.ClasspathEntry;
import io.takari.maven.plugins.compile.jdt.classpath.DependencyClasspathEntry;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.BundleException;

abstract class AbstractClasspathDirectory
extends DependencyClasspathEntry
implements ClasspathEntry {
    private final Map<String, Path> files;

    protected AbstractClasspathDirectory(Path directory, Set<String> packages, Map<String, Path> files) {
        super(directory, packages, AbstractClasspathDirectory.getExportedPackages(directory));
        this.files = Collections.unmodifiableMap(new LinkedHashMap<String, Path>(files));
    }

    protected static void scanDirectory(final Path basedir, final String suffix, final Set<String> packages, final Map<String, Path> files) {
        try {
            Files.walkFileTree(basedir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    String relpath = basedir.relativize(dir).toString();
                    if (!relpath.isEmpty()) {
                        packages.add(relpath.replace('\\', '/'));
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    String relpath = basedir.relativize(file).toString();
                    if (relpath.endsWith(suffix)) {
                        files.put(relpath.substring(0, relpath.length() - suffix.length()).replace('\\', '/'), file);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (NoSuchFileException noSuchFileException) {
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static Collection<String> getExportedPackages(Path directory) {
        InputStream is;
        Object var3_5;
        Throwable throwable;
        Collection<String> exportedPackages = null;
        try {
            throwable = null;
            var3_5 = null;
            try {
                is = Files.newInputStream(directory.resolve("META-INF/takari/export-package"), new OpenOption[0]);
                try {
                    exportedPackages = AbstractClasspathDirectory.parseExportPackage(is);
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {}
        if (exportedPackages == null) {
            try {
                throwable = null;
                var3_5 = null;
                try {
                    is = Files.newInputStream(directory.resolve("META-INF/MANIFEST.MF"), new OpenOption[0]);
                    try {
                        exportedPackages = AbstractClasspathDirectory.parseBundleManifest(is);
                    }
                    finally {
                        if (is != null) {
                            is.close();
                        }
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (IOException | BundleException throwable4) {}
        }
        return exportedPackages;
    }

    public Path getFile(String packageName, String typeName) {
        String qualifiedFileName = packageName + "/" + typeName;
        return this.files.get(qualifiedFileName);
    }
}

