/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.plugins.compile.jdt.classpath;

import io.takari.maven.plugins.compile.jdt.classpath.ClasspathEntry;
import io.takari.maven.plugins.compile.jdt.classpath.DependencyClasspathEntry;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.osgi.framework.BundleException;

public class ClasspathJar
extends DependencyClasspathEntry
implements ClasspathEntry {
    private final ZipFile zipFile;

    private ClasspathJar(Path file, ZipFile zipFile, Collection<String> packageNames, Collection<String> exportedPackages) throws IOException {
        super(file, packageNames, exportedPackages);
        this.zipFile = zipFile;
    }

    private static Set<String> getPackageNames(ZipFile zipFile) {
        HashSet<String> result = new HashSet<String>();
        Enumeration<? extends ZipEntry> e = zipFile.entries();
        while (e.hasMoreElements()) {
            ZipEntry entry = e.nextElement();
            String name = entry.getName();
            int last = name.lastIndexOf(47);
            while (last > 0) {
                name = name.substring(0, last);
                result.add(name);
                last = name.lastIndexOf(47);
            }
        }
        return result;
    }

    @Override
    public NameEnvironmentAnswer findType(String packageName, String typeName, AccessRestriction accessRestriction) {
        try {
            String qualifiedFileName = packageName + "/" + typeName + ".class";
            ClassFileReader reader = ClassFileReader.read((ZipFile)this.zipFile, (String)qualifiedFileName);
            if (reader != null) {
                return new NameEnvironmentAnswer((IBinaryType)reader, accessRestriction);
            }
        }
        catch (IOException | ClassFormatException throwable) {}
        return null;
    }

    public String toString() {
        return "Classpath for jar file " + this.file.toString();
    }

    public static ClasspathJar create(Path file) throws IOException {
        InputStream is;
        Object var6_8;
        Throwable throwable;
        ZipFile zipFile = new ZipFile(file.toFile());
        Set<String> packageNames = ClasspathJar.getPackageNames(zipFile);
        Collection<String> exportedPackages = null;
        ZipEntry entry = zipFile.getEntry("META-INF/takari/export-package");
        if (entry != null) {
            throwable = null;
            var6_8 = null;
            try {
                is = zipFile.getInputStream(entry);
                try {
                    exportedPackages = ClasspathJar.parseExportPackage(is);
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        if (exportedPackages == null && (entry = zipFile.getEntry("META-INF/MANIFEST.MF")) != null) {
            try {
                throwable = null;
                var6_8 = null;
                try {
                    is = zipFile.getInputStream(entry);
                    try {
                        exportedPackages = ClasspathJar.parseBundleManifest(is);
                    }
                    finally {
                        if (is != null) {
                            is.close();
                        }
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (BundleException bundleException) {}
        }
        return new ClasspathJar(file, zipFile, packageNames, exportedPackages);
    }
}

