/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.plugins.compile.jdt.classpath;

import io.takari.maven.plugins.compile.jdt.classpath.AbstractClasspathDirectory;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;

public class SourcepathDirectory
extends AbstractClasspathDirectory {
    private final String encoding;

    private SourcepathDirectory(Path directory, Set<String> packages, Map<String, Path> files, Charset encoding) {
        super(directory, packages, files);
        this.encoding = encoding != null ? encoding.name() : null;
    }

    @Override
    public NameEnvironmentAnswer findType(String packageName, String typeName, AccessRestriction accessRestriction) {
        Path javaFile = this.getFile(packageName, typeName);
        if (javaFile == null && typeName.indexOf("$") > 0) {
            javaFile = this.getFile(packageName, typeName.split("\\$")[0]);
        }
        if (javaFile != null) {
            ClasspathCompilationUnit cu = new ClasspathCompilationUnit(javaFile, this.encoding);
            return new NameEnvironmentAnswer((ICompilationUnit)cu, accessRestriction);
        }
        return null;
    }

    public String toString() {
        return "Sourcepath for directory " + String.valueOf(this.file);
    }

    public static SourcepathDirectory create(Path directory, Charset encoding) {
        HashSet<String> packages = new HashSet<String>();
        HashMap<String, Path> files = new HashMap<String, Path>();
        SourcepathDirectory.scanDirectory(directory, ".java", packages, files);
        return new SourcepathDirectory(directory, packages, files, encoding);
    }

    public static class ClasspathCompilationUnit
    extends CompilationUnit {
        public ClasspathCompilationUnit(Path file, String encoding) {
            super(null, file.toAbsolutePath().toString(), encoding, null, false, null);
        }
    }
}

