/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.plugins.configurator;

import java.util.Collection;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.lifecycle.MojoExecutionConfigurator;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;

@Singleton
@Named(value="takari")
public class TakariMojoExecutionConfigurator
implements MojoExecutionConfigurator {
    public void configure(MavenProject project, MojoExecution mojoExecution, boolean allowPluginLevelConfig) {
        String artifactId;
        String groupId = mojoExecution.getGroupId();
        Plugin plugin = this.findPlugin(groupId, artifactId = mojoExecution.getArtifactId(), project.getBuildPlugins());
        if (plugin == null && project.getPluginManagement() != null) {
            plugin = this.findPlugin(groupId, artifactId, project.getPluginManagement().getPlugins());
        }
        if (plugin != null) {
            Xpp3Dom mojoConfigurationFromPom;
            PluginExecution pluginExecution = this.findPluginExecution(mojoExecution.getExecutionId(), plugin.getExecutions());
            Xpp3Dom pomConfiguration = null;
            if (pluginExecution != null) {
                pomConfiguration = (Xpp3Dom)pluginExecution.getConfiguration();
            } else if (allowPluginLevelConfig) {
                pomConfiguration = (Xpp3Dom)plugin.getConfiguration();
            }
            Xpp3Dom xpp3Dom = mojoConfigurationFromPom = pomConfiguration != null ? new Xpp3Dom(pomConfiguration) : null;
            if (mojoConfigurationFromPom != null && mojoConfigurationFromPom.getChild(mojoExecution.getGoal()) != null && mojoConfigurationFromPom.getChild(mojoExecution.getGoal()).getChildCount() > 0) {
                mojoConfigurationFromPom = mojoConfigurationFromPom.getChild(mojoExecution.getGoal());
            }
            mojoConfigurationFromPom = Xpp3Dom.mergeXpp3Dom((Xpp3Dom)mojoConfigurationFromPom, (Xpp3Dom)mojoExecution.getConfiguration());
            mojoExecution.setConfiguration(mojoConfigurationFromPom);
        }
    }

    private Plugin findPlugin(String groupId, String artifactId, Collection<Plugin> plugins) {
        for (Plugin plugin : plugins) {
            if (!artifactId.equals(plugin.getArtifactId()) || !groupId.equals(plugin.getGroupId())) continue;
            return plugin;
        }
        return null;
    }

    private PluginExecution findPluginExecution(String executionId, Collection<PluginExecution> executions) {
        if (StringUtils.isNotEmpty((String)executionId)) {
            for (PluginExecution execution : executions) {
                if (!executionId.equals(execution.getId())) continue;
                return execution;
            }
        }
        return null;
    }
}

