/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.plugins.exportpackage;

import io.takari.incrementalbuild.Output;
import io.takari.incrementalbuild.aggregator.AggregatorBuildContext;
import io.takari.incrementalbuild.aggregator.InputSet;
import io.takari.incrementalbuild.aggregator.MetadataAggregator;
import io.takari.maven.plugins.TakariLifecycleMojo;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.inject.Inject;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="export-package", defaultPhase=LifecyclePhase.PROCESS_CLASSES, threadSafe=true)
public class ExportPackageMojo
extends TakariLifecycleMojo {
    public static final String PATH_EXPORT_PACKAGE = "META-INF/takari/export-package";
    public static final char EOL = '\n';
    @Parameter(defaultValue="${project.build.outputDirectory}/META-INF/takari/export-package")
    private File outputFile;
    @Parameter(defaultValue="${project.build.outputDirectory}")
    private File classesDirectory;
    @Parameter
    private Set<String> exportIncludes = Collections.emptySet();
    @Parameter
    private Set<String> exportExcludes = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList("**/internal/**", "**/impl/**")));
    @Inject
    private AggregatorBuildContext buildContext;

    @Override
    protected void executeMojo() throws MojoExecutionException {
        try {
            this.classesDirectory = this.classesDirectory.getCanonicalFile();
            this.generateOutput();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not generate export-package file", (Exception)e);
        }
    }

    private void generateOutput() throws IOException {
        InputSet output = this.buildContext.newInputSet();
        output.addInputs(this.classesDirectory, this.getIncludes(), this.exportExcludes);
        output.aggregateIfNecessary(this.outputFile, (MetadataAggregator)new MetadataAggregator<String>(){

            public Map<String, String> glean(File input) {
                return Collections.singletonMap(ExportPackageMojo.getPackageName(ExportPackageMojo.this.classesDirectory, input), null);
            }

            public void aggregate(Output<File> output, Map<String, String> metadata) throws IOException {
                TreeSet<String> exportedPackages = new TreeSet<String>(metadata.keySet());
                Throwable throwable = null;
                Object var5_6 = null;
                try (BufferedWriter w = new BufferedWriter(new OutputStreamWriter(output.newOutputStream(), StandardCharsets.UTF_8));){
                    for (String exportedPackage : exportedPackages) {
                        w.write(exportedPackage);
                        w.write(10);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private Collection<String> getIncludes() {
        if (this.exportIncludes.isEmpty()) {
            return Collections.singleton("**/*.class");
        }
        HashSet<String> includes = new HashSet<String>();
        for (String string : this.exportIncludes) {
            void var2_7;
            String string2 = string.replace('\\', '/');
            if (!string2.endsWith("/")) {
                String string3 = string2 + "/";
            }
            String string4 = (String)var2_7 + "*.class";
        }
        return includes;
    }

    static String getPackageName(File basedir, File file) {
        String relpath = basedir.toPath().relativize(file.getParentFile().toPath()).toString();
        return relpath.replace('\\', '/').replace('/', '.');
    }
}

