/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.plugins.packaging;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.inject.Provider;
import org.apache.maven.lifecycle.mapping.Lifecycle;
import org.apache.maven.lifecycle.mapping.LifecycleMapping;
import org.apache.maven.lifecycle.mapping.LifecyclePhase;

public abstract class LifecycleMappingSupport
implements Provider<LifecycleMapping> {
    private static final String DEFAULT_LIFECYCLE_KEY = "default";
    private final Lifecycle defaultLifecycle = new Lifecycle();
    private final LifecycleMapping lifecycleMapping;

    public LifecycleMappingSupport() {
        this.defaultLifecycle.setId(DEFAULT_LIFECYCLE_KEY);
        this.defaultLifecycle.setLifecyclePhases(this.loadMapping());
        this.lifecycleMapping = new LifecycleMapping(){

            public Map<String, Lifecycle> getLifecycles() {
                return Collections.singletonMap(LifecycleMappingSupport.DEFAULT_LIFECYCLE_KEY, LifecycleMappingSupport.this.defaultLifecycle);
            }

            public List<String> getOptionalMojos(String lifecycle) {
                return null;
            }

            public Map<String, String> getPhases(String lifecycle) {
                if (LifecycleMappingSupport.DEFAULT_LIFECYCLE_KEY.equals(lifecycle)) {
                    return LifecycleMappingSupport.this.defaultLifecycle.getPhases();
                }
                return null;
            }
        };
    }

    private Map<String, LifecyclePhase> loadMapping() {
        Properties properties = new Properties();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream inputStream = this.getClass().getResourceAsStream(this.getClass().getSimpleName() + ".properties");){
                properties.load(inputStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        HashMap<String, LifecyclePhase> result = new HashMap<String, LifecyclePhase>();
        for (String phase : properties.stringPropertyNames()) {
            result.put(phase, new LifecyclePhase(properties.getProperty(phase)));
        }
        return result;
    }

    public LifecycleMapping get() {
        return this.lifecycleMapping;
    }
}

