/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.plugins.plugin;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.plexus.util.StringUtils;

class GeneratorUtils {
    private GeneratorUtils() {
    }

    private static String quoteReplacement(String s) {
        if (s.indexOf(92) == -1 && s.indexOf(36) == -1) {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == '\\') {
                sb.append('\\');
                sb.append('\\');
            } else if (c == '$') {
                sb.append('\\');
                sb.append('$');
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    static String decodeJavadocTags(String description) {
        if (StringUtils.isEmpty((String)description)) {
            return "";
        }
        StringBuilder decoded = new StringBuilder(description.length() + 1024);
        Matcher matcher = Pattern.compile("\\{@(\\w+)\\s*([^\\}]*)\\}").matcher(description);
        while (matcher.find()) {
            String tag = matcher.group(1);
            Object text = matcher.group(2);
            text = StringUtils.replace((String)text, (String)"&", (String)"&amp;");
            text = StringUtils.replace((String)text, (String)"<", (String)"&lt;");
            text = StringUtils.replace((String)text, (String)">", (String)"&gt;");
            if ("code".equals(tag)) {
                text = "<code>" + (String)text + "</code>";
            } else if ("link".equals(tag) || "linkplain".equals(tag) || "value".equals(tag)) {
                String pattern = "(([^#\\.\\s]+\\.)*([^#\\.\\s]+))?(#([^\\(\\s]*)(\\([^\\)]*\\))?\\s*(\\S.*)?)?";
                Matcher link = Pattern.compile(pattern).matcher((CharSequence)text);
                if (link.matches() && StringUtils.isEmpty((String)(text = link.group(7)))) {
                    text = link.group(3);
                    if (StringUtils.isEmpty((String)text)) {
                        text = "";
                    }
                    if (StringUtils.isNotEmpty((String)link.group(5))) {
                        if (StringUtils.isNotEmpty((String)text)) {
                            text = (String)text + ".";
                        }
                        text = (String)text + link.group(5);
                        if (StringUtils.isNotEmpty((String)link.group(6))) {
                            text = (String)text + "()";
                        }
                    }
                }
                if (!"linkplain".equals(tag)) {
                    text = "<code>" + (String)text + "</code>";
                }
            }
            matcher.appendReplacement(decoded, text != null ? GeneratorUtils.quoteReplacement((String)text) : "");
        }
        matcher.appendTail(decoded);
        return decoded.toString();
    }
}

