/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.plugins.plugin.model;

import io.takari.maven.plugins.plugin.model.MojoParameter;
import io.takari.maven.plugins.plugin.model.MojoRequirement;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class MojoDescriptor
implements Serializable,
Cloneable {
    private List<String> superclasses;
    private String goal;
    private String description;
    private String since;
    private String requiresDependencyResolution;
    private String requiresDependencyCollection;
    private boolean requiresDirectInvocation = false;
    private boolean requiresProject = false;
    private boolean requiresReports = false;
    private boolean aggregator = false;
    private boolean requiresOnline = false;
    private boolean inheritedByDefault = false;
    private String phase;
    private String implementation;
    private String language;
    private String configurator;
    private String instantiationStrategy;
    private String executionStrategy;
    private boolean threadSafe = false;
    private String deprecated;
    private List<MojoParameter> parameters;
    private List<MojoRequirement> requirements;
    private boolean takariBuilder = false;

    public void addParameter(MojoParameter mojoParameter) {
        this.getParameters().add(mojoParameter);
    }

    public void addRequirement(MojoRequirement mojoRequirement) {
        this.getRequirements().add(mojoRequirement);
    }

    public void addSuperclasse(String string) {
        this.getSuperclasses().add(string);
    }

    public MojoDescriptor clone() {
        try {
            MojoDescriptor copy = (MojoDescriptor)super.clone();
            if (this.superclasses != null) {
                copy.superclasses = new ArrayList<String>();
                copy.superclasses.addAll(this.superclasses);
            }
            if (this.parameters != null) {
                copy.parameters = new ArrayList<MojoParameter>();
                for (MojoParameter mojoParameter : this.parameters) {
                    copy.parameters.add(mojoParameter.clone());
                }
            }
            if (this.requirements != null) {
                copy.requirements = new ArrayList<MojoRequirement>();
                for (MojoRequirement mojoRequirement : this.requirements) {
                    copy.requirements.add(mojoRequirement.clone());
                }
            }
            return copy;
        }
        catch (Exception ex) {
            throw (RuntimeException)new UnsupportedOperationException(this.getClass().getName() + " does not support clone()").initCause(ex);
        }
    }

    public String getConfigurator() {
        return this.configurator;
    }

    public String getDeprecated() {
        return this.deprecated;
    }

    public String getDescription() {
        return this.description;
    }

    public String getExecutionStrategy() {
        return this.executionStrategy;
    }

    public String getGoal() {
        return this.goal;
    }

    public String getImplementation() {
        return this.implementation;
    }

    public String getInstantiationStrategy() {
        return this.instantiationStrategy;
    }

    public String getLanguage() {
        return this.language;
    }

    public List<MojoParameter> getParameters() {
        if (this.parameters == null) {
            this.parameters = new ArrayList<MojoParameter>();
        }
        return this.parameters;
    }

    public String getPhase() {
        return this.phase;
    }

    public List<MojoRequirement> getRequirements() {
        if (this.requirements == null) {
            this.requirements = new ArrayList<MojoRequirement>();
        }
        return this.requirements;
    }

    public String getRequiresDependencyCollection() {
        return this.requiresDependencyCollection;
    }

    public String getRequiresDependencyResolution() {
        return this.requiresDependencyResolution;
    }

    public String getSince() {
        return this.since;
    }

    public List<String> getSuperclasses() {
        if (this.superclasses == null) {
            this.superclasses = new ArrayList<String>();
        }
        return this.superclasses;
    }

    public boolean isAggregator() {
        return this.aggregator;
    }

    public boolean isInheritedByDefault() {
        return this.inheritedByDefault;
    }

    public boolean isRequiresDirectInvocation() {
        return this.requiresDirectInvocation;
    }

    public boolean isRequiresOnline() {
        return this.requiresOnline;
    }

    public boolean isRequiresProject() {
        return this.requiresProject;
    }

    public boolean isRequiresReports() {
        return this.requiresReports;
    }

    public boolean isTakariBuilder() {
        return this.takariBuilder;
    }

    public boolean isThreadSafe() {
        return this.threadSafe;
    }

    public void removeParameter(MojoParameter mojoParameter) {
        this.getParameters().remove(mojoParameter);
    }

    public void removeRequirement(MojoRequirement mojoRequirement) {
        this.getRequirements().remove(mojoRequirement);
    }

    public void removeSuperclasse(String string) {
        this.getSuperclasses().remove(string);
    }

    public void setAggregator(boolean aggregator) {
        this.aggregator = aggregator;
    }

    public void setConfigurator(String configurator) {
        this.configurator = configurator;
    }

    public void setDeprecated(String deprecated) {
        this.deprecated = deprecated;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setExecutionStrategy(String executionStrategy) {
        this.executionStrategy = executionStrategy;
    }

    public void setGoal(String goal) {
        this.goal = goal;
    }

    public void setImplementation(String implementation) {
        this.implementation = implementation;
    }

    public void setInheritedByDefault(boolean inheritedByDefault) {
        this.inheritedByDefault = inheritedByDefault;
    }

    public void setInstantiationStrategy(String instantiationStrategy) {
        this.instantiationStrategy = instantiationStrategy;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setParameters(List<MojoParameter> parameters) {
        this.parameters = parameters;
    }

    public void setPhase(String phase) {
        this.phase = phase;
    }

    public void setRequirements(List<MojoRequirement> requirements) {
        this.requirements = requirements;
    }

    public void setRequiresDependencyCollection(String requiresDependencyCollection) {
        this.requiresDependencyCollection = requiresDependencyCollection;
    }

    public void setRequiresDependencyResolution(String requiresDependencyResolution) {
        this.requiresDependencyResolution = requiresDependencyResolution;
    }

    public void setRequiresDirectInvocation(boolean requiresDirectInvocation) {
        this.requiresDirectInvocation = requiresDirectInvocation;
    }

    public void setRequiresOnline(boolean requiresOnline) {
        this.requiresOnline = requiresOnline;
    }

    public void setRequiresProject(boolean requiresProject) {
        this.requiresProject = requiresProject;
    }

    public void setRequiresReports(boolean requiresReports) {
        this.requiresReports = requiresReports;
    }

    public void setSince(String since) {
        this.since = since;
    }

    public void setSuperclasses(List<String> superclasses) {
        this.superclasses = superclasses;
    }

    public void setTakariBuilder(boolean takariBuilder) {
        this.takariBuilder = takariBuilder;
    }

    public void setThreadSafe(boolean threadSafe) {
        this.threadSafe = threadSafe;
    }
}

