/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.plugins.testproperties;

import io.takari.incrementalbuild.BasicBuildContext;
import io.takari.incrementalbuild.Incremental;
import io.takari.incrementalbuild.Output;
import io.takari.incrementalbuild.Resource;
import io.takari.incrementalbuild.ResourceMetadata;
import io.takari.maven.plugins.util.PropertiesWriter;
import io.takari.resources.filtering.MissingPropertyAction;
import io.takari.resources.filtering.ResourcesProcessor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.ProjectDependencyGraph;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.m2e.workspace.MutableWorkspaceState;

@Mojo(name="testProperties", requiresDependencyResolution=ResolutionScope.TEST, configurator="takari", threadSafe=true)
public class TestPropertiesMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.properties}", readonly=true)
    private Properties projectProperties;
    @Parameter(defaultValue="${session.executionProperties}", readonly=true)
    private Properties sessionProperties;
    @Incremental(configuration=Incremental.Configuration.ignore)
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${project.groupId}", readonly=true)
    private String groupId;
    @Parameter(defaultValue="${project.artifactId}", readonly=true)
    private String artifactId;
    @Parameter(defaultValue="${project.version}", readonly=true)
    private String version;
    @Parameter(defaultValue="${session.request.userSettingsFile}", readonly=true)
    private File userSettingsFile;
    @Parameter(defaultValue="${session.request.globalSettingsFile}", readonly=true)
    private File globalSettingsFile;
    @Parameter(defaultValue="${project.basedir}/src/test/test.properties")
    private File testProperties;
    @Parameter(defaultValue="${project.build.testOutputDirectory}/test.properties")
    private File outputFile;
    @Parameter(defaultValue="${project.artifactMap(io.takari.m2e.workspace:org.eclipse.m2e.workspace.cli)}", readonly=true)
    private Artifact workspaceResolver;
    @Parameter(defaultValue="${project.build.directory}/workspacestate.properties")
    private File workspaceState;
    @Parameter(defaultValue="${project.build.outputDirectory}", readonly=true)
    private File outputDirectory;
    @Parameter(defaultValue="${project.artifacts}", readonly=true)
    private Set<Artifact> dependencies;
    @Parameter(defaultValue="${session.request.offline}", readonly=true)
    private boolean offline;
    @Parameter(defaultValue="${session.request.updateSnapshots}", readonly=true)
    private boolean updateSnapshots;
    @Incremental(configuration=Incremental.Configuration.ignore)
    @Parameter(defaultValue="${session.projectDependencyGraph}", readonly=true)
    private ProjectDependencyGraph reactorDependencies;
    @Incremental(configuration=Incremental.Configuration.ignore)
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repositorySystemSession;
    @Parameter
    protected MissingPropertyAction missingPropertyAction = MissingPropertyAction.DEFAULT;
    @Component
    private BasicBuildContext context;
    @Component
    private ResourcesProcessor resourceProcessor;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            if (!this.context.isProcessingRequired()) {
                return;
            }
            Properties properties = new Properties();
            Output output = this.context.processOutput(this.outputFile);
            if (this.testProperties.canRead()) {
                this.mergeCustomTestProperties(output, properties);
            }
            TestPropertiesMojo.putIfAbsent(properties, "localRepository", this.repositorySystemSession.getLocalRepository().getBasedir().getAbsolutePath());
            if (this.isAccessible(this.userSettingsFile)) {
                TestPropertiesMojo.putIfAbsent(properties, "userSettingsFile", this.userSettingsFile.getAbsolutePath());
            } else {
                this.logWarningNotAccessibleFile(this.userSettingsFile);
            }
            if (this.isAccessible(this.globalSettingsFile)) {
                TestPropertiesMojo.putIfAbsent(properties, "globalSettingsFile", this.globalSettingsFile.getAbsolutePath());
            } else {
                this.logWarningNotAccessibleFile(this.globalSettingsFile);
            }
            List repositories = this.project.getRemoteArtifactRepositories();
            int i = 0;
            while (i < repositories.size()) {
                properties.put("repository." + i, this.toString((ArtifactRepository)repositories.get(i)));
                ++i;
            }
            TestPropertiesMojo.putIfAbsent(properties, "offline", Boolean.toString(this.offline));
            TestPropertiesMojo.putIfAbsent(properties, "updateSnapshots", Boolean.toString(this.updateSnapshots));
            TestPropertiesMojo.putIfAbsent(properties, "project.groupId", this.groupId);
            TestPropertiesMojo.putIfAbsent(properties, "project.artifactId", this.artifactId);
            TestPropertiesMojo.putIfAbsent(properties, "project.version", this.version);
            TestPropertiesMojo.putIfAbsent(properties, "classpath", this.getClasspathString());
            if (this.workspaceResolver != null && this.workspaceResolver.getFile() != null) {
                TestPropertiesMojo.putIfAbsent(properties, "workspaceResolver", this.workspaceResolver.getFile().getAbsolutePath());
            }
            this.writeWorkspaceState();
            TestPropertiesMojo.putIfAbsent(properties, "workspaceStateProperties", this.workspaceState.getAbsolutePath());
            Throwable throwable = null;
            Object var5_8 = null;
            try (OutputStream os = output.newOutputStream();){
                PropertiesWriter.write(properties, "Generated by " + ((Object)((Object)this)).getClass().getName(), os);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not create test.properties file", (Exception)e);
        }
    }

    private String toString(ArtifactRepository repository) {
        StringBuilder sb = new StringBuilder();
        sb.append("<id>").append(repository.getId()).append("</id>");
        sb.append("<url>").append(repository.getUrl()).append("</url>");
        sb.append("<releases><enabled>").append(repository.getReleases().isEnabled()).append("</enabled></releases>");
        sb.append("<snapshots><enabled>").append(repository.getSnapshots().isEnabled()).append("</enabled></snapshots>");
        return sb.toString();
    }

    private String getClasspathString() {
        Set<String> scopes = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList("compile", "runtime")));
        StringBuilder sb = new StringBuilder();
        sb.append(this.outputDirectory.getAbsolutePath());
        for (Artifact dependency : this.dependencies) {
            if (!scopes.contains(dependency.getScope())) continue;
            sb.append(File.pathSeparatorChar);
            sb.append(dependency.getFile().getAbsolutePath());
        }
        return sb.toString();
    }

    private void writeWorkspaceState() throws MojoExecutionException {
        MutableWorkspaceState state = new MutableWorkspaceState();
        state.putPom(this.project.getFile(), this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion());
        state.putArtifact(this.outputDirectory, this.project.getGroupId(), this.project.getArtifactId(), "jar", null, this.project.getVersion());
        if (this.reactorDependencies != null) {
            for (Throwable other : this.reactorDependencies.getUpstreamProjects(this.project, true)) {
                TestPropertiesMojo.putProject(state, (MavenProject)other);
            }
        }
        try {
            Throwable other;
            other = null;
            Iterator iterator = null;
            try (OutputStream os = this.context.processOutput(this.workspaceState).newOutputStream();){
                PropertiesWriter.write(state.asProperties(), null, os);
            }
            catch (Throwable throwable) {
                if (other == null) {
                    other = throwable;
                } else if (other != throwable) {
                    other.addSuppressed(throwable);
                }
                throw other;
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not create reactor state file " + String.valueOf(this.workspaceState), (Exception)e);
        }
    }

    private static void putProject(MutableWorkspaceState state, MavenProject other) {
        state.putPom(other.getFile(), other.getGroupId(), other.getArtifactId(), other.getVersion());
        if (other.getArtifact().getFile() != null) {
            TestPropertiesMojo.putArtifact(state, other.getArtifact());
        }
        for (Artifact artifact : other.getAttachedArtifacts()) {
            TestPropertiesMojo.putArtifact(state, artifact);
        }
    }

    private static void putArtifact(MutableWorkspaceState state, Artifact artifact) {
        state.putArtifact(artifact.getFile(), artifact.getGroupId(), artifact.getArtifactId(), artifact.getArtifactHandler().getExtension(), artifact.getClassifier(), artifact.getBaseVersion());
    }

    private void mergeCustomTestProperties(Output output, Properties properties) throws MojoExecutionException {
        ResourceMetadata metadata = this.context.registerInput(this.testProperties);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (FileInputStream is = new FileInputStream((File)metadata.getResource());){
                Properties custom = new Properties();
                custom.load(is);
                this.mergeCustomTestProperties((Resource)output, properties, custom);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not read test.properties file " + String.valueOf(this.testProperties), (Exception)e);
        }
    }

    private void mergeCustomTestProperties(Resource resource, Properties properties, Properties custom) {
        HashMap<Object, Object> substitutes = new HashMap<Object, Object>();
        for (Artifact dependency : this.dependencies) {
            StringBuilder key = new StringBuilder();
            key.append(dependency.getGroupId());
            key.append(':').append(dependency.getArtifactId());
            if (dependency.getClassifier() != null) {
                key.append(':').append(dependency.getClassifier());
            }
            substitutes.put(key.toString(), dependency.getFile());
        }
        substitutes.putAll(this.projectProperties);
        substitutes.putAll(this.sessionProperties);
        substitutes.put("project", this.project);
        substitutes.put("localRepository", this.repositorySystemSession.getLocalRepository().getBasedir().getAbsolutePath());
        substitutes.put("userSettingsFile", this.userSettingsFile);
        for (String key : custom.stringPropertyNames()) {
            properties.put(key, this.expand(resource, custom.getProperty(key), substitutes));
        }
    }

    private static void putIfAbsent(Properties properties, String key, String value) {
        if (!properties.containsKey(key)) {
            properties.put(key, value);
        }
    }

    private String expand(Resource resource, String value, Map<Object, Object> substitutes) {
        StringWriter writer = new StringWriter();
        try {
            this.resourceProcessor.filter(resource, new StringReader(value), writer, substitutes, this.missingPropertyAction);
            return writer.toString();
        }
        catch (IOException iOException) {
            return value;
        }
    }

    private boolean isAccessible(File file) {
        return file != null && file.isFile() && file.canRead();
    }

    private void logWarningNotAccessibleFile(File file) {
        if (file != null) {
            String msg = "File '" + file.getAbsolutePath() + "' ";
            msg = file.exists() && !file.isFile() ? msg + "exists, but it is not a regular file!" : (file.exists() && file.isFile() && !file.canRead() ? msg + "exists, but can not be read!" : msg + "does not exist!");
            msg = msg + " It will be ignored.";
            this.getLog().warn((CharSequence)msg);
        }
    }
}

