/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.testing.executor.junit;

import io.takari.maven.testing.executor.MavenInstallationUtils;
import io.takari.maven.testing.executor.MavenInstallations;
import io.takari.maven.testing.executor.MavenRuntime;
import io.takari.maven.testing.executor.MavenVersions;
import io.takari.maven.testing.executor.junit.MavenVersionResolver;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.Suite;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

public class MavenJUnitTestRunner
extends Suite {
    public MavenJUnitTestRunner(Class<?> clazz) throws Throwable {
        super(clazz, MavenJUnitTestRunner.getRunners(clazz));
    }

    private static List<Runner> getRunners(final Class<?> clazz) throws Throwable {
        MavenVersions versions;
        File forcedMavenHome = MavenInstallationUtils.getForcedMavenHome();
        File forcedClassworldsConf = MavenInstallationUtils.getForcedClassworldsConf();
        if (forcedMavenHome != null) {
            if (forcedMavenHome.isDirectory() || forcedClassworldsConf != null && forcedClassworldsConf.isFile()) {
                String version = MavenInstallationUtils.getMavenVersion(forcedMavenHome, forcedClassworldsConf);
                return Collections.singletonList(new SingleMavenInstallationRunner(clazz, forcedMavenHome, forcedClassworldsConf, version));
            }
            throw new InitializationError((Throwable)new Exception("Invalid -Dmaven.home=" + forcedMavenHome.getAbsolutePath()));
        }
        final ArrayList<Exception> errors = new ArrayList<Exception>();
        final ArrayList<Runner> runners = new ArrayList<Runner>();
        MavenInstallations installations = clazz.getAnnotation(MavenInstallations.class);
        if (installations != null) {
            String[] stringArray = installations.value();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String installation = stringArray[n2];
                File mavenHome = new File(installation).getCanonicalFile();
                if (mavenHome.isDirectory()) {
                    runners.add((Runner)new SingleMavenInstallationRunner(clazz, mavenHome, null, installation));
                } else {
                    errors.add(new Exception("Invalid maven installation location " + installation));
                }
                ++n2;
            }
        }
        if ((versions = clazz.getAnnotation(MavenVersions.class)) != null) {
            new MavenVersionResolver(){

                @Override
                protected void resolved(File mavenHome, String version) throws InitializationError {
                    runners.add(new SingleMavenInstallationRunner(clazz, mavenHome, null, version));
                }

                @Override
                protected void error(String version, Exception cause) {
                    errors.add(new Exception("Could not resolve maven version " + version, cause));
                }
            }.resolve(versions.value());
        }
        if (!errors.isEmpty()) {
            throw new InitializationError(errors);
        }
        if (runners.isEmpty()) {
            throw new InitializationError((Throwable)new Exception("No configured test maven runtime"));
        }
        return runners;
    }

    private static class SingleMavenInstallationRunner
    extends BlockJUnit4ClassRunner {
        private final File mavenHome;
        private final File classworldsConf;
        private final String name;

        SingleMavenInstallationRunner(Class<?> klass, File mavenHome, File classworldsConf, String name) throws InitializationError {
            super(klass);
            this.mavenHome = mavenHome;
            this.classworldsConf = classworldsConf;
            this.name = name;
        }

        protected Object createTest() throws Exception {
            MavenRuntime.MavenRuntimeBuilder builder = MavenRuntime.builder(this.mavenHome, this.classworldsConf);
            return this.getTestClass().getJavaClass().getConstructor(MavenRuntime.MavenRuntimeBuilder.class).newInstance(builder);
        }

        protected void validateZeroArgConstructor(List<Throwable> errors) {
            try {
                this.getTestClass().getJavaClass().getConstructor(MavenRuntime.MavenRuntimeBuilder.class);
            }
            catch (NoSuchMethodException e) {
                errors.add(e);
            }
        }

        protected String getName() {
            return "[" + this.name + "]";
        }

        protected String testName(FrameworkMethod method) {
            return String.valueOf(method.getName()) + this.getName();
        }

        protected Statement classBlock(RunNotifier notifier) {
            return this.childrenInvoker(notifier);
        }
    }
}

