/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.testing.executor.junit;

import io.takari.maven.testing.executor.MavenInstallations;
import io.takari.maven.testing.executor.junit.MavenHomeUtils;
import io.takari.maven.testing.executor.junit.MavenInstallationDisplayNameFormatter;
import io.takari.maven.testing.executor.junit.MavenInstallationTestInvocationContext;
import java.util.Arrays;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContextProvider;

final class MavenInstallationsTestExtension
implements TestTemplateInvocationContextProvider {
    MavenInstallationsTestExtension() {
    }

    public boolean supportsTestTemplate(ExtensionContext context) {
        if (MavenHomeUtils.isForced()) {
            return false;
        }
        return context.getTestClass().map(clazz -> clazz.isAnnotationPresent(MavenInstallations.class)).orElse(false);
    }

    public Stream<TestTemplateInvocationContext> provideTestTemplateInvocationContexts(ExtensionContext context) {
        String displayName = context.getDisplayName();
        String[] installations = ((Class)context.getTestClass().get()).getAnnotation(MavenInstallations.class).value();
        return Arrays.stream(installations).map(installation -> new MavenInstallationTestInvocationContext((String)installation, new MavenInstallationDisplayNameFormatter(displayName)));
    }
}

