/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.testing.executor;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.codehaus.plexus.classworlds.ClassWorldException;
import org.codehaus.plexus.classworlds.launcher.ConfigurationException;
import org.codehaus.plexus.classworlds.launcher.ConfigurationHandler;
import org.codehaus.plexus.classworlds.launcher.ConfigurationParser;
import org.codehaus.plexus.classworlds.realm.DuplicateRealmException;
import org.codehaus.plexus.classworlds.realm.NoSuchRealmException;

public class MavenInstallationUtils {
    public static final String MAVEN_CORE_POMPROPERTIES = "META-INF/maven/org.apache.maven/maven-core/pom.properties";
    public static final String SYSPROP_MAVEN_HOME = "maven.home";
    public static final String SYSPROP_CLASSWORLDSCONF = "classworlds.conf";
    public static final String SYSPROP_MAVEN_MAIN_CLASS = "maven.mainClass";
    public static final String MAVEN3_MAIN_CLASS = "org.apache.maven.cli.MavenCli";
    public static final String MAVEN4_MAIN_CLASS = "org.apache.maven.cling.MavenCling";

    public static String getMavenVersion(Class<?> clazz) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (InputStream is = clazz.getResourceAsStream("/META-INF/maven/org.apache.maven/maven-core/pom.properties");){
            return MavenInstallationUtils.getMavenVersion(is);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static String getMavenVersion(InputStream is) throws IOException {
        Properties props = new Properties();
        if (is != null) {
            props.load(is);
        }
        return props.getProperty("version");
    }

    public static String getMavenVersion(File mavenHome, File classworldsConf) {
        class MavenVersionFoundException
        extends RuntimeException {
            public final String version;

            MavenVersionFoundException(String version) {
                this.version = version;
            }
        }
        classworldsConf = MavenInstallationUtils.getClassworldsConf(mavenHome, classworldsConf);
        try {
            class VersionConfigHandler
            implements ConfigurationHandler {
                VersionConfigHandler() {
                }

                public void setAppMain(String mainClassName, String mainRealmName) {
                }

                public void addRealm(String realmName) throws DuplicateRealmException {
                }

                public void addImportFrom(String relamName, String importSpec) throws NoSuchRealmException {
                }

                public void addLoadFile(File file) {
                    String version = null;
                    try {
                        block31: {
                            if (file.isFile()) {
                                Throwable throwable = null;
                                Object var4_7 = null;
                                try (ZipFile zip = new ZipFile(file);){
                                    ZipEntry entry = zip.getEntry(MavenInstallationUtils.MAVEN_CORE_POMPROPERTIES);
                                    if (entry == null) break block31;
                                    Throwable throwable2 = null;
                                    Object var8_16 = null;
                                    try (InputStream is = zip.getInputStream(entry);){
                                        version = MavenInstallationUtils.getMavenVersion(is);
                                        break block31;
                                    }
                                    catch (Throwable throwable3) {
                                        if (throwable2 == null) {
                                            throwable2 = throwable3;
                                        } else if (throwable2 != throwable3) {
                                            throwable2.addSuppressed(throwable3);
                                        }
                                        throw throwable2;
                                    }
                                }
                                catch (Throwable throwable4) {
                                    if (throwable == null) {
                                        throwable = throwable4;
                                    } else if (throwable != throwable4) {
                                        throwable.addSuppressed(throwable4);
                                    }
                                    throw throwable;
                                }
                            }
                            Throwable throwable = null;
                            Object var4_9 = null;
                            try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(new File(file, MavenInstallationUtils.MAVEN_CORE_POMPROPERTIES)));){
                                version = MavenInstallationUtils.getMavenVersion(is);
                            }
                            catch (Throwable throwable5) {
                                if (throwable == null) {
                                    throwable = throwable5;
                                } else if (throwable != throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                                throw throwable;
                            }
                        }
                        if (version != null) {
                            throw new MavenVersionFoundException(version);
                        }
                    }
                    catch (IOException iOException) {}
                }

                public void addLoadURL(URL url) {
                }
            }
            VersionConfigHandler configHandler = new VersionConfigHandler();
            Properties properties = new Properties(System.getProperties());
            properties.setProperty(SYSPROP_MAVEN_MAIN_CLASS, MAVEN4_MAIN_CLASS);
            properties.setProperty(SYSPROP_MAVEN_HOME, mavenHome.getCanonicalPath());
            ConfigurationParser configParser = new ConfigurationParser((ConfigurationHandler)configHandler, properties);
            Throwable throwable = null;
            Object var6_9 = null;
            try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(classworldsConf));){
                configParser.parse((InputStream)is);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | ClassWorldException | ConfigurationException e) {
            throw new IllegalArgumentException("Could not determine Maven version", e);
        }
        catch (MavenVersionFoundException e) {
            return e.version;
        }
        throw new IllegalArgumentException("Could not determine Maven version");
    }

    public static File getForcedClassworldsConf() {
        File configFile = null;
        String classworldConf = System.getProperty(SYSPROP_CLASSWORLDSCONF);
        String mavenHome = System.getProperty(SYSPROP_MAVEN_HOME);
        if (classworldConf != null) {
            configFile = new File(classworldConf);
        }
        if (configFile == null && mavenHome != null) {
            configFile = new File(mavenHome, "bin/m2.conf");
        }
        return configFile;
    }

    public static File getForcedMavenHome() {
        String mavenHome = System.getProperty(SYSPROP_MAVEN_HOME);
        if (mavenHome != null) {
            return new File(mavenHome);
        }
        return null;
    }

    public static File getClassworldsConf(File mavenHome, File classworldsConf) {
        if (classworldsConf == null) {
            classworldsConf = new File(mavenHome, "bin/m2.conf");
        }
        return classworldsConf;
    }
}

