/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.testing.executor.junit;

import io.takari.maven.testing.executor.junit.MavenInstallationDisplayNameFormatter;
import io.takari.maven.testing.executor.junit.MavenRuntimeBuilderParameterResolver;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;

final class MavenInstallationTestInvocationContext
implements TestTemplateInvocationContext {
    private final MavenInstallationDisplayNameFormatter formatter;
    private final String installation;

    MavenInstallationTestInvocationContext(String installation, MavenInstallationDisplayNameFormatter formatter) {
        this.installation = installation;
        this.formatter = formatter;
    }

    public String getDisplayName(int invocationIndex) {
        return this.formatter.format(this.installation);
    }

    public List<Extension> getAdditionalExtensions() {
        File mavenHome;
        try {
            mavenHome = new File(this.installation).getCanonicalFile();
        }
        catch (IOException e) {
            throw new ExtensionConfigurationException("could not access maven installation: " + this.installation, (Throwable)e);
        }
        if (mavenHome.isDirectory()) {
            return Collections.singletonList(new MavenRuntimeBuilderParameterResolver(mavenHome));
        }
        throw new ExtensionConfigurationException("Invalid maven installation location " + this.installation);
    }
}

