/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.builder.smart;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import io.takari.maven.builder.smart.SmartBuilderImpl;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BuildProgressReportThread
extends Thread
implements SmartBuilderImpl.Listener {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    final ConcurrencyTracker executing = new ConcurrencyTracker();
    final AtomicInteger blockedProjects = new AtomicInteger();
    final AtomicInteger notReady;
    private static final int POLLER_SLEEP_MS = 500;
    volatile boolean stop;
    private long startTimeMs;
    private final int degreeOfConcurrency;

    public BuildProgressReportThread(int projectCount, int degreeOfConcurrency) {
        super(BuildProgressReportThread.class.getName());
        this.degreeOfConcurrency = degreeOfConcurrency;
        this.startTimeMs = System.currentTimeMillis();
        this.notReady = new AtomicInteger(projectCount);
        this.setDaemon(true);
    }

    @Override
    public void run() {
        String lastKeyString = "";
        long backoffLeft = 1L;
        long backoffCount = 1L;
        while (!this.stop) {
            int execCount = this.executing.executingCount();
            TimeAveraged delta = this.executing.getDelta();
            TimeAveraged overall = this.executing.getOverall();
            String elapsedMs = String.format("%6s (ms) : ", System.currentTimeMillis() - this.startTimeMs);
            String message = elapsedMs + "Executing=" + execCount + ", blocked=" + this.blockedProjects.get() + ", not ready=" + this.notReady.get() + ", delta conc=" + this.asPercent(delta) + "%, avg conc=" + this.asPercent(overall) + "%" + "\nLTB : " + elapsedMs + "Targets: [" + this.execString(this.executing.getTrackers()) + "]";
            String keyString = this.executing.getTrackers().keySet().toString();
            if (!lastKeyString.equals(keyString)) {
                backoffCount = 1L;
                backoffLeft = 1L;
                this.logger.info(message);
                delta.start();
                lastKeyString = keyString;
            } else if (backoffLeft-- <= 0L) {
                this.logger.info(message);
                delta.start();
                backoffLeft = backoffCount *= 2L;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                SmartBuilderImpl.checkState(this.stop, "IE recieved when not stopped");
            }
        }
    }

    private String execString(ConcurrentMap<String, TimeAveraged> executing) {
        long now = System.nanoTime();
        ArrayList output = Lists.newArrayList();
        for (Map.Entry entry : executing.entrySet()) {
            TimeAveraged avg = (TimeAveraged)entry.getValue();
            output.add((String)entry.getKey() + " (exec=" + TimeUnit.NANOSECONDS.toMillis(now - avg.getStartNanos()) + "ms, conc=" + this.asPercent(avg) + "%)");
        }
        return Joiner.on((String)", ").join((Iterable)output);
    }

    public void terminate() {
        this.stop = true;
        this.interrupt();
    }

    String asPercent(TimeAveraged avg) {
        return this.asPercent(avg, 0);
    }

    private String asPercent(TimeAveraged avg, int precision) {
        return String.format("%." + precision + "f", 100.0 * avg.averagedValue() / (double)this.degreeOfConcurrency);
    }

    @Override
    public void onReady(MavenProject project) {
        this.notReady.decrementAndGet();
        this.blockedProjects.incrementAndGet();
    }

    @Override
    public void onStart(MavenProject project) {
        this.blockedProjects.decrementAndGet();
        this.executing.startTask(project.getId());
    }

    @Override
    public void onFinish(MavenProject project) {
        this.executing.stopTask(project.getId());
    }

    private static class ConcurrencyTracker {
        private TimeAveraged overall;
        private TimeAveraged delta;
        private final ConcurrentMap<String, TimeAveraged> trackers = new ConcurrentHashMap<String, TimeAveraged>();

        private ConcurrencyTracker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void startTask(String name) {
            SmartBuilderImpl.checkState(!this.trackers.containsKey(name), "duplicate task name: " + name);
            TimeAveraged ret = new TimeAveraged();
            ConcurrencyTracker concurrencyTracker = this;
            synchronized (concurrencyTracker) {
                ret.start(this.trackers.size());
                this.trackers.put(name, ret);
                for (TimeAveraged existing : this.trackers.values()) {
                    existing.increment();
                }
                if (this.overall == null) {
                    this.overall = new TimeAveraged().start(1.0);
                    this.delta = new TimeAveraged().start(1.0);
                } else {
                    this.overall.increment();
                    this.delta.increment();
                }
                this.delta.hashCode();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long stopTask(String name) {
            this.overall.decrement();
            this.delta.decrement();
            ConcurrencyTracker concurrencyTracker = this;
            synchronized (concurrencyTracker) {
                TimeAveraged removed = (TimeAveraged)this.trackers.remove(name);
                SmartBuilderImpl.checkState(removed != null, String.format("task isn't being tracked: %s", name));
                for (TimeAveraged existing : this.trackers.values()) {
                    existing.decrement();
                }
                return System.nanoTime() - removed.getStartNanos();
            }
        }

        public ConcurrentMap<String, TimeAveraged> getTrackers() {
            return this.trackers;
        }

        public int executingCount() {
            return this.trackers.size();
        }

        public synchronized TimeAveraged getOverall() {
            return this.overall == null ? new TimeAveraged() : this.overall;
        }

        public synchronized TimeAveraged getDelta() {
            return this.delta == null ? new TimeAveraged() : this.delta;
        }
    }

    private static class TimeAveraged {
        private long startNanos;
        private long lastNanos;
        private double value;
        private long accumulatedNanos;
        private double accumulatedProduct;

        public synchronized TimeAveraged start(double value) {
            this.startNanos = this.lastNanos = this.now();
            this.accumulatedNanos = 0L;
            this.accumulatedProduct = 0L;
            this.value = value;
            return this;
        }

        public synchronized TimeAveraged start() {
            return this.start(this.value);
        }

        long now() {
            return System.nanoTime();
        }

        public synchronized TimeAveraged increment() {
            this.setValue(this.value + 1.0);
            return this;
        }

        public synchronized TimeAveraged decrement() {
            this.setValue(this.value - 1.0);
            return this;
        }

        public synchronized void setValue(double newValue) {
            long now = this.now();
            long deltaNanos = now - this.lastNanos;
            this.accumulatedProduct += (double)deltaNanos * this.value;
            this.accumulatedNanos += deltaNanos;
            this.lastNanos = now;
            this.value = newValue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public double averagedValue() {
            long nanos;
            double product;
            double value;
            TimeAveraged timeAveraged = this;
            synchronized (timeAveraged) {
                value = this.value;
                this.setValue(value);
                product = this.accumulatedProduct;
                nanos = this.accumulatedNanos;
            }
            return nanos == 0L ? value : product / (double)nanos;
        }

        public synchronized long getStartNanos() {
            return this.startNanos;
        }

        public String toString() {
            return String.valueOf(this.averagedValue());
        }
    }
}

