/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.builder.smart;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.maven.lifecycle.internal.BuildThreadFactory;
import org.apache.maven.project.MavenProject;

class ProjectExecutorService {
    private final ExecutorService executor;
    private final BlockingQueue<MavenProject> completion = new LinkedBlockingQueue<MavenProject>();
    private final Comparator<Runnable> taskComparator;

    public ProjectExecutorService(int degreeOfConcurrency, final Comparator<MavenProject> projectComparator) {
        this.taskComparator = new Comparator<Runnable>(){

            @Override
            public int compare(Runnable o1, Runnable o2) {
                return projectComparator.compare(((ProjectRunnable)o1).getProject(), ((ProjectRunnable)o2).getProject());
            }
        };
        PriorityBlockingQueue<Runnable> executorWorkQueue = new PriorityBlockingQueue<Runnable>(degreeOfConcurrency, this.taskComparator);
        this.executor = new ThreadPoolExecutor(degreeOfConcurrency, degreeOfConcurrency, 0L, TimeUnit.MILLISECONDS, executorWorkQueue, (ThreadFactory)new BuildThreadFactory()){

            @Override
            protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
                return new ProjectFutureTask(runnable);
            }

            @Override
            protected void beforeExecute(Thread t, Runnable r) {
                ProjectExecutorService.this.beforeExecute(t, r);
            }
        };
    }

    public void submitAll(Collection<? extends ProjectRunnable> tasks) {
        ArrayList<? extends ProjectRunnable> sorted = new ArrayList<ProjectRunnable>(tasks);
        Collections.sort(sorted, this.taskComparator);
        for (ProjectRunnable projectRunnable : sorted) {
            this.executor.submit(projectRunnable, null);
        }
    }

    public MavenProject take() throws InterruptedException {
        return this.completion.take();
    }

    public void shutdown() throws InterruptedException {
        this.executor.shutdown();
        while (!this.executor.awaitTermination(5L, TimeUnit.SECONDS)) {
        }
    }

    protected void beforeExecute(Thread t, Runnable r) {
    }

    private class ProjectFutureTask<V>
    extends FutureTask<V>
    implements ProjectRunnable {
        private ProjectRunnable task;

        public ProjectFutureTask(Runnable task) {
            super(task, null);
            this.task = (ProjectRunnable)task;
        }

        @Override
        protected void done() {
            ProjectExecutorService.this.completion.add(this.task.getProject());
        }

        @Override
        public MavenProject getProject() {
            return this.task.getProject();
        }
    }

    static interface ProjectRunnable
    extends Runnable {
        public MavenProject getProject();
    }
}

