/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.builder.smart;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class BuildMetrics
implements Comparable<BuildMetrics> {
    private final Map<Timer, ThreadSafeStopwatch> timers;

    public BuildMetrics() {
        ConcurrentHashMap<Timer, ThreadSafeStopwatch> timers = new ConcurrentHashMap<Timer, ThreadSafeStopwatch>();
        Timer[] timerArray = Timer.values();
        int n = timerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Timer t = timerArray[n2];
            timers.put(t, new ThreadSafeStopwatch());
            ++n2;
        }
        this.timers = Collections.unmodifiableMap(timers);
    }

    public void start(Timer timer) {
        this.timers.get((Object)timer).start();
    }

    public void stop(Timer timer) {
        this.timers.get((Object)timer).stop();
    }

    public long getMetricElapsedTime(Timer timer, TimeUnit desiredUnit) {
        return this.timers.get((Object)timer).elapsed(desiredUnit);
    }

    public long getMetricMillis(Timer timer) {
        return this.getMetricElapsedTime(timer, TimeUnit.MILLISECONDS);
    }

    public String toString() {
        return String.format("wall time (ms) = %d, service time (ms) = %d, queue time (ms) = %d", this.getMetricMillis(Timer.WALLTIME_MS), this.getMetricMillis(Timer.SERVICETIME_MS), this.getMetricMillis(Timer.QUEUETIME_MS));
    }

    @Override
    public int compareTo(BuildMetrics bm) {
        return this.descCompare(bm);
    }

    private int descCompare(BuildMetrics bm) {
        long delta = this.getMetricMillis(Timer.WALLTIME_MS) - bm.getMetricMillis(Timer.WALLTIME_MS);
        return delta < 0L ? 1 : (delta > 0L ? -1 : 0);
    }

    private static class ThreadSafeStopwatch {
        private long start;
        private long stop;

        private ThreadSafeStopwatch() {
        }

        public synchronized void start() {
            this.start = System.nanoTime();
        }

        public synchronized void stop() {
            this.stop = System.nanoTime();
        }

        public synchronized long elapsed(TimeUnit desiredUnit) {
            long duration = this.stop > 0L ? this.stop - this.start : System.nanoTime() - this.start;
            return desiredUnit.convert(duration, TimeUnit.NANOSECONDS);
        }
    }

    public static enum Timer {
        WALLTIME_MS,
        QUEUETIME_MS,
        SERVICETIME_MS;

    }
}

