/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.builder.smart;

import io.takari.maven.builder.smart.BuildMetrics;
import io.takari.maven.builder.smart.ProjectsBuildMetrics;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.ProjectDependencyGraph;
import org.apache.maven.project.MavenProject;

class ProjectComparator {
    ProjectComparator() {
    }

    public static Comparator<MavenProject> create(MavenSession session) {
        ProjectDependencyGraph dependencyGraph = session.getProjectDependencyGraph();
        Map<String, Long> historicalServiceTimes = ProjectComparator.readServiceTimes(session);
        return ProjectComparator.create(dependencyGraph, historicalServiceTimes);
    }

    public static Comparator<MavenProject> create(ProjectDependencyGraph dependencyGraph, Map<String, Long> historicalServiceTimes) {
        long defaultServiceTime = ProjectComparator.average(historicalServiceTimes.values());
        HashMap<MavenProject, Long> serviceTimes = new HashMap<MavenProject, Long>();
        HashSet<MavenProject> rootProjects = new HashSet<MavenProject>();
        for (MavenProject project : dependencyGraph.getSortedProjects()) {
            Long serviceTime = ProjectComparator.getServiceTime(historicalServiceTimes, project, defaultServiceTime);
            serviceTimes.put(project, serviceTime);
            if (!dependencyGraph.getUpstreamProjects(project, false).isEmpty()) continue;
            rootProjects.add(project);
        }
        final Map<MavenProject, Long> projectWeights = ProjectComparator.calculateWeights(dependencyGraph, serviceTimes, rootProjects);
        return new Comparator<MavenProject>(){

            @Override
            public int compare(MavenProject o1, MavenProject o2) {
                long delta = (Long)projectWeights.get(o2) - (Long)projectWeights.get(o1);
                if (delta > 0L) {
                    return 1;
                }
                if (delta < 0L) {
                    return -1;
                }
                return ProjectComparator.id(o2).compareTo(ProjectComparator.id(o1));
            }
        };
    }

    private static long average(Collection<Long> values) {
        long count = 0L;
        long sum = 0L;
        for (Long value : values) {
            if (value == null) continue;
            sum += value.longValue();
            ++count;
        }
        long average = 0L;
        if (count > 0L) {
            average = sum / count;
        }
        if (average == 0L) {
            average = 1L;
        }
        return average;
    }

    private static long parseServiceTime(String string) {
        try {
            long value = Long.parseLong(string);
            return value > 0L ? value : 0L;
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
    }

    private static Long getServiceTime(Map<String, Long> serviceTimes, MavenProject project, long defaultServiceTime) {
        Long serviceTime = serviceTimes.get(ProjectComparator.id(project));
        return serviceTime != null ? serviceTime : defaultServiceTime;
    }

    private static Map<MavenProject, Long> calculateWeights(ProjectDependencyGraph dependencyGraph, Map<MavenProject, Long> serviceTimes, Collection<MavenProject> rootProjects) {
        HashMap<MavenProject, Long> weights = new HashMap<MavenProject, Long>();
        for (MavenProject rootProject : rootProjects) {
            ProjectComparator.calculateWeights(dependencyGraph, serviceTimes, rootProject, weights);
        }
        return weights;
    }

    private static long calculateWeights(ProjectDependencyGraph dependencyGraph, Map<MavenProject, Long> serviceTimes, MavenProject project, Map<MavenProject, Long> weights) {
        long weight = serviceTimes.get(project);
        for (MavenProject successor : dependencyGraph.getDownstreamProjects(project, false)) {
            long successorWeight = weights.containsKey(successor) ? weights.get(successor) : ProjectComparator.calculateWeights(dependencyGraph, serviceTimes, successor, weights);
            weight = Math.max(weight, serviceTimes.get(project) + successorWeight);
        }
        weights.put(project, weight);
        return weight;
    }

    private static Map<String, Long> readServiceTimes(MavenSession session) {
        HashMap<String, Long> result = new HashMap<String, Long>();
        File timingFile = ProjectComparator.getTimingFile(session);
        Properties properties = new Properties();
        if (timingFile != null) {
            try {
                Throwable throwable = null;
                Iterator<String> iterator = null;
                try (FileInputStream is = new FileInputStream(timingFile);){
                    properties.load(is);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {}
            for (String id : properties.stringPropertyNames()) {
                result.put(id, ProjectComparator.parseServiceTime(properties.getProperty(id)));
            }
        }
        return result;
    }

    private static File getTimingFile(MavenSession session) {
        File mvndir = new File(session.getRequest().getBaseDirectory(), ".mvn");
        return mvndir.isDirectory() ? new File(mvndir, "timing.properties") : null;
    }

    public static String id(MavenProject project) {
        StringBuilder sb = new StringBuilder();
        sb.append(project.getGroupId());
        sb.append(':');
        sb.append(project.getArtifactId());
        sb.append(':');
        sb.append(project.getVersion());
        return sb.toString();
    }

    public static void writeServiceTimes(MavenSession session, ProjectsBuildMetrics metrics) throws IOException {
        File timingFile = ProjectComparator.getTimingFile(session);
        if (timingFile != null) {
            Properties properties = new Properties();
            for (MavenProject project : metrics.getProjects()) {
                long serviceTime = metrics.getBuildMetrics(project).getMetricMillis(BuildMetrics.Timer.SERVICETIME_MS);
                properties.put(ProjectComparator.id(project), Long.toString(serviceTime));
            }
            Throwable throwable = null;
            Iterator<MavenProject> iterator = null;
            try (FileOutputStream os = new FileOutputStream(timingFile);){
                properties.store(os, null);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    public static Comparator<MavenProject> create(ProjectDependencyGraph projectDependencyGraph, ProjectsBuildMetrics projectsBuildMetrics) {
        HashMap<String, Long> serviceTimes = new HashMap<String, Long>();
        for (Map.Entry<MavenProject, Long> entry : projectsBuildMetrics.asMap(BuildMetrics.Timer.SERVICETIME_MS).entrySet()) {
            serviceTimes.put(ProjectComparator.id(entry.getKey()), entry.getValue());
        }
        return ProjectComparator.create(projectDependencyGraph, serviceTimes);
    }
}

