/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.builder.smart;

import com.google.common.base.Functions;
import com.google.common.collect.Ordering;
import io.takari.maven.builder.smart.BuildMetrics;
import io.takari.maven.builder.smart.SmartBuilderImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.project.MavenProject;

class ProjectsBuildMetrics
implements SmartBuilderImpl.Listener {
    private final Map<MavenProject, BuildMetrics> projectsBuildMetrics;

    ProjectsBuildMetrics(Collection<MavenProject> projects) {
        HashMap<MavenProject, BuildMetrics> projectsBuildMetrics = new HashMap<MavenProject, BuildMetrics>();
        for (MavenProject project : projects) {
            projectsBuildMetrics.put(project, new BuildMetrics());
        }
        this.projectsBuildMetrics = Collections.unmodifiableMap(projectsBuildMetrics);
    }

    public BuildMetrics getBuildMetrics(MavenProject project) {
        return this.projectsBuildMetrics.get(project);
    }

    private void start(MavenProject project, BuildMetrics.Timer timer) {
        this.projectsBuildMetrics.get(project).start(timer);
    }

    private void stop(MavenProject project, BuildMetrics.Timer timer) {
        this.projectsBuildMetrics.get(project).stop(timer);
    }

    public List<MavenProject> getProjects() {
        return new ArrayList<MavenProject>(this.projectsBuildMetrics.keySet());
    }

    public List<MavenProject> getProjectsSortedByWalltime() {
        return Ordering.natural().onResultOf(Functions.forMap(this.projectsBuildMetrics)).sortedCopy(this.projectsBuildMetrics.keySet());
    }

    @Override
    public void onReady(MavenProject project) {
        this.start(project, BuildMetrics.Timer.QUEUETIME_MS);
    }

    @Override
    public void onStart(MavenProject project) {
        this.stop(project, BuildMetrics.Timer.QUEUETIME_MS);
        this.start(project, BuildMetrics.Timer.SERVICETIME_MS);
    }

    @Override
    public void onFinish(MavenProject project) {
        this.stop(project, BuildMetrics.Timer.SERVICETIME_MS);
    }

    public Map<MavenProject, Long> asMap(BuildMetrics.Timer timer) {
        HashMap<MavenProject, Long> result = new HashMap<MavenProject, Long>();
        for (Map.Entry<MavenProject, BuildMetrics> entry : this.projectsBuildMetrics.entrySet()) {
            result.put(entry.getKey(), entry.getValue().getMetricMillis(timer));
        }
        return result;
    }
}

