/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.builder.smart;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.execution.ProjectDependencyGraph;
import org.apache.maven.project.MavenProject;

class ReactorBuildQueue {
    private final ProjectDependencyGraph dependencyGraph;
    private final Set<MavenProject> rootProjects;
    private final Collection<MavenProject> projects;
    private final Set<MavenProject> blockedProjects = new HashSet<MavenProject>();
    private final Set<MavenProject> finishedProjects = new HashSet<MavenProject>();

    public ReactorBuildQueue(ProjectDependencyGraph dependencyGraph) {
        this.dependencyGraph = dependencyGraph;
        List projects = dependencyGraph.getSortedProjects();
        HashSet<MavenProject> rootProjects = new HashSet<MavenProject>();
        for (MavenProject project : projects) {
            if (dependencyGraph.getUpstreamProjects(project, false).isEmpty()) {
                rootProjects.add(project);
                continue;
            }
            this.blockedProjects.add(project);
        }
        this.rootProjects = Collections.unmodifiableSet(rootProjects);
        this.projects = Collections.unmodifiableList(projects);
    }

    public Set<MavenProject> onProjectFinish(MavenProject project) {
        this.finishedProjects.add(project);
        HashSet<MavenProject> downstreamProjects = new HashSet<MavenProject>();
        for (MavenProject successor : this.getDownstreamProjects(project)) {
            if (!this.blockedProjects.contains(successor) || !this.isProjectReady(successor)) continue;
            this.blockedProjects.remove(successor);
            downstreamProjects.add(successor);
        }
        return downstreamProjects;
    }

    public List<MavenProject> getDownstreamProjects(MavenProject project) {
        return this.dependencyGraph.getDownstreamProjects(project, false);
    }

    private boolean isProjectReady(MavenProject project) {
        for (MavenProject upstream : this.dependencyGraph.getUpstreamProjects(project, false)) {
            if (this.finishedProjects.contains(upstream)) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        return this.blockedProjects.isEmpty();
    }

    public Set<MavenProject> getRootProjects() {
        return this.rootProjects;
    }

    public int getBlockedCount() {
        return this.blockedProjects.size();
    }

    public int getFinishedCount() {
        return this.finishedProjects.size();
    }

    public int getReadyCount() {
        return this.projects.size() - this.blockedProjects.size() - this.finishedProjects.size();
    }

    public Set<MavenProject> getReadyProjects() {
        HashSet<MavenProject> projects = new HashSet<MavenProject>(this.projects);
        projects.removeAll(this.blockedProjects);
        projects.removeAll(this.finishedProjects);
        return projects;
    }
}

