/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.builder.smart;

import com.google.common.base.Joiner;
import io.takari.maven.builder.smart.BuildMetrics;
import io.takari.maven.builder.smart.BuildProgressReportThread;
import io.takari.maven.builder.smart.ProjectComparator;
import io.takari.maven.builder.smart.ProjectExecutorService;
import io.takari.maven.builder.smart.ProjectsBuildMetrics;
import io.takari.maven.builder.smart.ReactorBuildQueue;
import io.takari.maven.builder.smart.SmartBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.maven.execution.BuildFailure;
import org.apache.maven.execution.BuildSuccess;
import org.apache.maven.execution.BuildSummary;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.internal.LifecycleModuleBuilder;
import org.apache.maven.lifecycle.internal.ReactorContext;
import org.apache.maven.lifecycle.internal.TaskSegment;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SmartBuilderImpl {
    private final Logger logger = LoggerFactory.getLogger(SmartBuilder.class);
    private final LifecycleModuleBuilder lifecycleModuleBuilder;
    private final MavenSession rootSession;
    private final ReactorContext reactorContext;
    private final List<TaskSegment> taskSegments;
    private final List<Listener> listeners;
    private final ReactorBuildQueue reactorBuildQueue;
    private final ProjectExecutorService executor;
    private final BuildProgressReportThread progressReporter;
    private final int degreeOfConcurrency;
    private final ProjectsBuildMetrics projectsBuildMetrics;

    SmartBuilderImpl(LifecycleModuleBuilder lifecycleModuleBuilder, MavenSession session, ReactorContext reactorContext, List<TaskSegment> taskSegments) {
        this.lifecycleModuleBuilder = lifecycleModuleBuilder;
        this.rootSession = session;
        this.reactorContext = reactorContext;
        this.taskSegments = taskSegments;
        List projects = session.getProjects();
        this.degreeOfConcurrency = session.getRequest().getDegreeOfConcurrency();
        ArrayList<Listener> listeners = new ArrayList<Listener>();
        this.projectsBuildMetrics = new ProjectsBuildMetrics(projects);
        listeners.add(this.projectsBuildMetrics);
        BuildProgressReportThread progressReporter = null;
        if (this.isProfiling()) {
            progressReporter = new BuildProgressReportThread(projects.size(), this.degreeOfConcurrency);
            progressReporter.start();
            listeners.add(progressReporter);
        }
        this.progressReporter = progressReporter;
        Comparator<MavenProject> projectComparator = ProjectComparator.create(session);
        this.reactorBuildQueue = new ReactorBuildQueue(session.getProjectDependencyGraph());
        this.listeners = Collections.unmodifiableList(listeners);
        this.executor = new ProjectExecutorService(this.degreeOfConcurrency, projectComparator);
    }

    public void build() throws ExecutionException, InterruptedException {
        Set<MavenProject> readyProjects;
        long buildStopwatch = System.currentTimeMillis();
        Set<MavenProject> rootProjects = this.reactorBuildQueue.getRootProjects();
        this.log("Task segments : " + Joiner.on((String)",").join(this.taskSegments));
        this.log("Build maximum degree of concurrency is " + this.degreeOfConcurrency);
        this.log("Root level projects are " + Joiner.on((String)",").join(rootProjects));
        this.submitAll(rootProjects);
        for (int submittedCount = rootProjects.size(); submittedCount > 0; submittedCount += readyProjects.size()) {
            --submittedCount;
            try {
                MavenProject completedProject = this.executor.take();
                this.logCompleted(completedProject);
                readyProjects = this.reactorBuildQueue.onProjectFinish(completedProject);
                this.submitAll(readyProjects);
                this.logBuildQueueStatus();
                continue;
            }
            catch (ExecutionException e) {
                this.shutdown();
                throw e;
            }
        }
        this.shutdown();
        long buildStopwatchEnd = System.currentTimeMillis();
        try {
            ProjectComparator.writeServiceTimes(this.rootSession, this.projectsBuildMetrics);
        }
        catch (IOException e) {
            throw new ExecutionException(e);
        }
        if (this.isProfiling()) {
            this.report(buildStopwatchEnd - buildStopwatch);
        }
    }

    private void logBuildQueueStatus() {
        int blockedCount = this.reactorBuildQueue.getBlockedCount();
        int finishedCount = this.reactorBuildQueue.getFinishedCount();
        int readyCount = this.reactorBuildQueue.getReadyCount();
        String runningProjects = "";
        if (readyCount < this.degreeOfConcurrency && blockedCount > 0) {
            StringBuffer sb = new StringBuffer();
            sb.append('[');
            for (MavenProject project : this.reactorBuildQueue.getReadyProjects()) {
                if (sb.length() > 1) {
                    sb.append(' ');
                }
                sb.append(this.projectGA(project));
            }
            sb.append(']');
            runningProjects = sb.toString();
        }
        this.logger.info("Builder state: blocked={} finished={} ready-or-running={} {}", new Object[]{blockedCount, finishedCount, readyCount, runningProjects});
    }

    private void logCompleted(MavenProject project) {
        BuildSummary buildSummary = this.rootSession.getResult().getBuildSummary(project);
        String message = "SKIPPED";
        if (buildSummary instanceof BuildSuccess) {
            message = "SUCCESS";
        } else if (buildSummary instanceof BuildFailure) {
            message = "FAILURE";
        } else if (buildSummary != null) {
            this.logger.warn("Unexpected project build summary class {}", buildSummary.getClass());
            message = "UNKNOWN";
        }
        this.logger.info("{} build of project {}", (Object)message, (Object)this.projectGA(project));
    }

    private String projectGA(MavenProject project) {
        return String.valueOf(project.getGroupId()) + ":" + project.getArtifactId();
    }

    private void shutdown() {
        this.executor.shutdown();
        if (this.progressReporter != null) {
            this.progressReporter.terminate();
        }
    }

    private void report(long wallTime) {
        List projects = this.rootSession.getProjects();
        int projectCount = projects.size();
        List<MavenProject> criticalPath = this.calculateCriticalPath();
        long criticalPathTime = this.totalTime(criticalPath);
        float schedullingEfficiency = (float)criticalPathTime / (float)wallTime;
        this.logger.info("Smart builder : projects={}, wallTime={} ms, criticalPathTime={} ms, schedullingEfficiency={} %", new Object[]{projectCount, wallTime, criticalPathTime, String.format("%3.2f", Float.valueOf(schedullingEfficiency * 100.0f))});
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("Smart builder : critical path projects %d time %d ms (project serviceTime ms queueTime ms):", criticalPath.size(), criticalPathTime));
        this.appendBuildMetrics(sb, criticalPath);
        this.logger.info(sb.toString());
        sb = new StringBuilder();
        sb.append(String.format("Smart builder : all projects %d (project serviceTime ms queueTime ms):", projectCount));
        this.appendBuildMetrics(sb, projects);
        this.logger.info(sb.toString());
    }

    private void appendBuildMetrics(StringBuilder result, List<MavenProject> projects) {
        for (MavenProject project : projects) {
            if (result.length() > 0) {
                result.append("\n   ");
            }
            BuildMetrics metrics = this.projectsBuildMetrics.getBuildMetrics(project);
            long serviceTime = metrics.getMetricMillis(BuildMetrics.Timer.SERVICETIME_MS);
            long queueTime = metrics.getMetricMillis(BuildMetrics.Timer.QUEUETIME_MS);
            result.append(project.getGroupId()).append(':').append(project.getArtifactId());
            result.append(' ').append(serviceTime).append(' ').append(queueTime);
        }
    }

    private long totalTime(List<MavenProject> projects) {
        long total = 0L;
        for (MavenProject project : projects) {
            total += this.projectsBuildMetrics.getBuildMetrics(project).getMetricMillis(BuildMetrics.Timer.SERVICETIME_MS);
        }
        return total;
    }

    private List<MavenProject> calculateCriticalPath() {
        ArrayList<MavenProject> criticalPath = new ArrayList<MavenProject>();
        Comparator<MavenProject> comparator = ProjectComparator.create(this.rootSession.getProjectDependencyGraph(), this.projectsBuildMetrics);
        MavenProject project = this.getCriticalProject(this.reactorBuildQueue.getRootProjects(), comparator);
        do {
            criticalPath.add(project);
        } while ((project = this.getCriticalProject(this.reactorBuildQueue.getDownstreamProjects(project), comparator)) != null);
        return criticalPath;
    }

    private MavenProject getCriticalProject(Collection<MavenProject> projects, Comparator<MavenProject> comparator) {
        if (projects == null || projects.isEmpty()) {
            return null;
        }
        ArrayList<MavenProject> sorted = new ArrayList<MavenProject>(projects);
        Collections.sort(sorted, comparator);
        return (MavenProject)sorted.get(0);
    }

    private void submitAll(Set<MavenProject> readyProjects) {
        this.printReadyQueue(readyProjects);
        ArrayList<ProjectBuildTask> tasks = new ArrayList<ProjectBuildTask>();
        for (MavenProject project : readyProjects) {
            for (Listener listener : this.listeners) {
                listener.onReady(project);
            }
            tasks.add(new ProjectBuildTask(project));
            this.logger.info("Ready {}", (Object)this.projectGA(project));
        }
        this.executor.submitAll(tasks);
    }

    void buildProject(MavenProject project) {
        this.log("Starting " + project.getName());
        long projectStopwatch = System.currentTimeMillis();
        try {
            try {
                MavenSession copiedSession = this.rootSession.clone();
                for (TaskSegment taskSegment : this.taskSegments) {
                    this.lifecycleModuleBuilder.buildProject(copiedSession, this.rootSession, this.reactorContext, project, taskSegment);
                }
            }
            catch (RuntimeException ex) {
                this.rootSession.getResult().addException((Throwable)new RuntimeException(String.valueOf(project.getName()) + ": " + ex.getMessage(), ex));
                this.log("Completed servicing " + project.getName() + " : " + (System.currentTimeMillis() - projectStopwatch) + " (ms).");
            }
        }
        finally {
            this.log("Completed servicing " + project.getName() + " : " + (System.currentTimeMillis() - projectStopwatch) + " (ms).");
        }
    }

    private boolean isProfiling() {
        return System.getProperty("maven.profile") != null;
    }

    private void printReadyQueue(Collection<MavenProject> readyQueue) {
        if (this.isProfiling() && !readyQueue.isEmpty()) {
            this.log("================================");
            for (MavenProject project : readyQueue) {
                this.log(project.getName());
            }
            this.log("--------------------------------");
        }
    }

    public void log(String s) {
        if (this.isProfiling()) {
            this.logger.info("Smart Builder : " + s);
        }
    }

    static void checkState(boolean b, String string) {
        if (!b) {
            throw new RuntimeException(string);
        }
    }

    static interface Listener {
        public void onReady(MavenProject var1);

        public void onStart(MavenProject var1);

        public void onFinish(MavenProject var1);
    }

    class ProjectBuildTask
    implements ProjectExecutorService.ProjectRunnable {
        private final MavenProject project;

        ProjectBuildTask(MavenProject project) {
            this.project = project;
        }

        @Override
        public void run() {
            for (Listener listener : SmartBuilderImpl.this.listeners) {
                listener.onStart(this.project);
            }
            SmartBuilderImpl.this.buildProject(this.project);
            for (Listener listener : SmartBuilderImpl.this.listeners) {
                listener.onFinish(this.project);
            }
        }

        @Override
        public MavenProject getProject() {
            return this.project;
        }
    }
}

