/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.maven.polyglot.execute;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Build;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.Profile;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.sonatype.maven.polyglot.Constants;
import org.sonatype.maven.polyglot.PolyglotModelManager;
import org.sonatype.maven.polyglot.execute.ExecuteManager;
import org.sonatype.maven.polyglot.execute.ExecuteTask;

@Component(role=ExecuteManager.class)
public class ExecuteManagerImpl
implements ExecuteManager {
    @Requirement
    protected Logger log;
    @Requirement
    protected PolyglotModelManager manager;
    private final Map<String, List<ExecuteTask>> modelTasks = new HashMap<String, List<ExecuteTask>>();

    @Override
    public void register(Model model, List<ExecuteTask> tasks) {
        assert (model != null);
        assert (tasks != null);
        ArrayList<ExecuteTask> copy = new ArrayList<ExecuteTask>(tasks.size());
        copy.addAll(tasks);
        this.modelTasks.put(model.getId(), Collections.unmodifiableList(copy));
    }

    @Override
    public List<ExecuteTask> getTasks(Model model) {
        Model inheritingModel;
        assert (model != null);
        List<ExecuteTask> tasks = this.modelTasks.get(model.getId());
        if (tasks == null) {
            inheritingModel = new Model();
            inheritingModel.setArtifactId(model.getArtifactId());
            inheritingModel.setPackaging(model.getPackaging());
            inheritingModel.setVersion(model.getVersion());
            tasks = this.modelTasks.get(inheritingModel.getId());
        }
        if (tasks == null) {
            inheritingModel = new Model();
            inheritingModel.setArtifactId(model.getArtifactId());
            inheritingModel.setGroupId(model.getGroupId());
            inheritingModel.setPackaging(model.getPackaging());
            tasks = this.modelTasks.get(inheritingModel.getId());
        }
        if (tasks == null) {
            inheritingModel = new Model();
            inheritingModel.setArtifactId(model.getArtifactId());
            inheritingModel.setPackaging(model.getPackaging());
            tasks = this.modelTasks.get(inheritingModel.getId());
        }
        if (tasks == null) {
            return Collections.emptyList();
        }
        return tasks;
    }

    @Override
    public void install(Model model, Map<String, ?> options) {
        assert (model != null);
        List<ExecuteTask> tasks = this.getTasks(model);
        if (tasks.isEmpty()) {
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Registering tasks for: " + model.getId());
        }
        List<String> goals = Collections.singletonList("execute");
        HashMap<String, Plugin> plugins = new HashMap<String, Plugin>();
        for (ExecuteTask task : tasks) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Registering task: " + task.getId());
            }
            Plugin plugin = this.getPlugin(model, task.getProfileId(), plugins);
            String id = task.getId();
            PluginExecution execution = new PluginExecution();
            if (id != null && id.length() > 0) {
                execution.setId(id);
            }
            execution.setPhase(task.getPhase());
            execution.setGoals(goals);
            Xpp3Dom config = new Xpp3Dom("configuration");
            execution.setConfiguration((Object)config);
            if (id != null && id.length() > 0) {
                Xpp3Dom child = new Xpp3Dom("taskId");
                child.setValue(id);
                config.addChild(child);
            }
            if (model.getPomFile() != null) {
                Xpp3Dom nativePom = new Xpp3Dom("nativePom");
                nativePom.setValue(model.getPomFile().getName());
                config.addChild(nativePom);
            }
            plugin.addExecution(execution);
        }
        String flavour = this.manager.getFlavourFor(options);
        for (Plugin plugin : plugins.values()) {
            Dependency dep = new Dependency();
            dep.setGroupId(Constants.getGroupId());
            dep.setArtifactId(Constants.getArtifactId(flavour));
            dep.setVersion(Constants.getVersion());
            plugin.addDependency(dep);
        }
    }

    private BuildBase getBuild(Model model, String profileId) {
        if (profileId == null) {
            if (model.getBuild() == null) {
                model.setBuild(new Build());
            }
            return model.getBuild();
        }
        for (Profile p : model.getProfiles()) {
            if (!profileId.equals(p.getId())) continue;
            if (p.getBuild() == null) {
                p.setBuild((BuildBase)new Build());
            }
            return p.getBuild();
        }
        Profile profile = new Profile();
        profile.setId(profileId);
        profile.setBuild((BuildBase)new Build());
        model.addProfile(profile);
        return profile.getBuild();
    }

    private Plugin getPlugin(Model model, String profileId, Map<String, Plugin> plugins) {
        Plugin plugin = plugins.get(profileId);
        if (plugin == null) {
            plugin = new Plugin();
            plugin.setGroupId(Constants.getGroupId());
            plugin.setArtifactId(Constants.getArtifactId("maven-plugin"));
            plugin.setVersion(Constants.getVersion());
            BuildBase build = this.getBuild(model, profileId);
            List existingPlugins = build.getPlugins();
            ArrayList mutablePlugins = new ArrayList(existingPlugins);
            build.setPlugins(mutablePlugins);
            build.addPlugin(plugin);
            plugins.put(profileId, plugin);
        }
        return plugin;
    }
}

